/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.vcache.internal.core.service;

import com.atlassian.vcache.JvmCacheSettings;
import com.atlassian.vcache.VCacheException;
import com.atlassian.vcache.internal.NameValidator;
import com.atlassian.vcache.internal.core.service.AbstractLockingJvmCache;
import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.google.common.util.concurrent.UncheckedExecutionException;
import java.time.Duration;
import java.util.HashSet;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.function.Supplier;
import javax.annotation.Nonnull;

public class GuavaJvmCache<K, V>
extends AbstractLockingJvmCache<K, V> {
    private final String name;
    private final Cache<K, V> delegate;

    public GuavaJvmCache(String name, JvmCacheSettings settings) {
        this.name = NameValidator.requireValidCacheName((String)name);
        this.delegate = CacheBuilder.newBuilder().maximumSize((long)((Integer)settings.getMaxEntries().get()).intValue()).expireAfterAccess(((Duration)settings.getDefaultTtl().get()).toMillis(), TimeUnit.MILLISECONDS).build();
    }

    @Override
    @Nonnull
    protected V decoratedGet(K key, Supplier<? extends V> supplier) {
        try {
            return (V)this.delegate.get(Objects.requireNonNull(key), supplier::get);
        }
        catch (UncheckedExecutionException | ExecutionException e) {
            throw new VCacheException("Supplier failed", e);
        }
    }

    @Override
    protected void decoratedRemove(K key) {
        this.delegate.invalidate(key);
    }

    @Override
    protected void decoratedRemoveAll() {
        this.delegate.invalidateAll();
    }

    @Nonnull
    public Set<K> getKeys() {
        return new HashSet(this.delegate.asMap().keySet());
    }

    @Nonnull
    public Optional<V> get(K key) {
        return Optional.ofNullable(this.delegate.getIfPresent(key));
    }

    public void put(K key, V value) {
        this.delegate.put(Objects.requireNonNull(key), Objects.requireNonNull(value));
    }

    @Nonnull
    public Optional<V> putIfAbsent(K key, V value) {
        return Optional.ofNullable(this.delegate.asMap().putIfAbsent(Objects.requireNonNull(key), Objects.requireNonNull(value)));
    }

    public boolean replaceIf(K key, V currentValue, V newValue) {
        return this.delegate.asMap().replace(Objects.requireNonNull(key), Objects.requireNonNull(currentValue), Objects.requireNonNull(newValue));
    }

    public boolean removeIf(K key, V value) {
        return this.delegate.asMap().remove(key, value);
    }

    @Nonnull
    public String getName() {
        return this.name;
    }
}

