/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.vcache.internal.core;

import com.atlassian.vcache.internal.RequestContext;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Supplier;
import javax.annotation.Nonnull;

public class DefaultRequestContext
implements RequestContext {
    private final String partitionId;
    private final Map<Object, Object> map = new HashMap<Object, Object>();

    public DefaultRequestContext(String partitionId) {
        this.partitionId = Objects.requireNonNull(partitionId);
    }

    @Nonnull
    public String partitionIdentifier() {
        return this.partitionId;
    }

    @Nonnull
    public <T> T computeIfAbsent(Object key, Supplier<T> supplier) {
        if (this.map.containsKey(Objects.requireNonNull(key))) {
            return (T)this.map.get(key);
        }
        T v = Objects.requireNonNull(supplier.get());
        this.map.put(key, v);
        return v;
    }

    @Nonnull
    public <T> Optional<T> get(Object key) {
        return Optional.ofNullable(this.map.get(key));
    }
}

