/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.admin.adminheader;

import com.atlassian.jira.plugin.webfragment.SimpleLinkManager;
import com.atlassian.jira.plugin.webfragment.model.JiraHelper;
import com.atlassian.jira.plugin.webfragment.model.SimpleLink;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.jira.web.ExecutingHttpRequest;
import com.atlassian.plugin.web.model.WebPanel;
import com.atlassian.soy.renderer.SoyException;
import com.atlassian.soy.renderer.SoyTemplateRenderer;
import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GeneralAdminHeaderPanel
implements WebPanel {
    private final SoyTemplateRenderer soyTemplateRenderer;
    public static final String SYSTEM_ADMIN_HEADER_PAGEACTIONS = "system.admin.header.pageactions";
    private final SimpleLinkManager simpleLinkManager;
    private static final Logger log = LoggerFactory.getLogger(GeneralAdminHeaderPanel.class);
    private final JiraAuthenticationContext authenticationContext;

    public GeneralAdminHeaderPanel(SoyTemplateRenderer soyTemplateRenderer, SimpleLinkManager simpleLinkManager, JiraAuthenticationContext authenticationContext) {
        this.soyTemplateRenderer = soyTemplateRenderer;
        this.simpleLinkManager = simpleLinkManager;
        this.authenticationContext = authenticationContext;
    }

    public String getHtml(Map<String, Object> stringObjectMap) {
        try {
            JiraHelper jiraHelper = new JiraHelper(ExecutingHttpRequest.get());
            List items = this.simpleLinkManager.getLinksForSection(SYSTEM_ADMIN_HEADER_PAGEACTIONS, this.authenticationContext.getUser(), jiraHelper);
            ArrayList<String> actions = new ArrayList<String>(items.size());
            for (SimpleLink link : items) {
                actions.add(new PageAction(link, this.soyTemplateRenderer).getHtml());
            }
            stringObjectMap.put("pageActions", actions);
            return this.soyTemplateRenderer.render("com.atlassian.jira.jira-admin-navigation-plugin:admin-header-new-nav-soy", "JIRA.Templates.header.admin.adminheading", stringObjectMap);
        }
        catch (SoyException e) {
            log.warn("Could not render soy template for admin header");
            log.debug("Exception: ", (Throwable)e);
            return null;
        }
    }

    public void writeHtml(Writer writer, Map<String, Object> stringObjectMap) throws IOException {
        try {
            JiraHelper jiraHelper = new JiraHelper(ExecutingHttpRequest.get());
            List items = this.simpleLinkManager.getLinksForSection(SYSTEM_ADMIN_HEADER_PAGEACTIONS, this.authenticationContext.getUser(), jiraHelper);
            ArrayList<String> actions = new ArrayList<String>(items.size());
            for (SimpleLink link : items) {
                actions.add(new PageAction(link, this.soyTemplateRenderer).getHtml());
            }
            stringObjectMap.put("pageActions", actions);
            this.soyTemplateRenderer.render((Appendable)writer, "com.atlassian.jira.jira-admin-navigation-plugin:admin-header-new-nav-soy", "JIRA.Templates.header.admin.adminheading", stringObjectMap);
        }
        catch (SoyException e) {
            log.warn("Could not render soy template for admin header");
            log.debug("Exception: ", (Throwable)e);
        }
    }

    public static class PageAction {
        private final SimpleLink link;
        private final SoyTemplateRenderer soyTemplateRenderer;

        private PageAction(SimpleLink link, SoyTemplateRenderer soyTemplateRenderer) {
            this.link = link;
            this.soyTemplateRenderer = soyTemplateRenderer;
        }

        public String getHtml() {
            try {
                String iconClass;
                HashMap<String, String> data = new HashMap<String, String>();
                data.put("id", this.link.getId());
                data.put("url", this.link.getUrl());
                data.put("text", this.link.getLabel());
                data.put("extraClasses", this.link.getStyleClass());
                String string = iconClass = null != this.link.getParams() ? (String)this.link.getParams().get("iconClass") : "";
                if (!StringUtils.isEmpty((String)iconClass)) {
                    data.put("iconType", "custom");
                    data.put("iconClass", "icon " + iconClass);
                    data.put("iconText", "");
                }
                return this.soyTemplateRenderer.render("jira.webresources:soy-templates", "JIRA.Templates.Links.button", data);
            }
            catch (SoyException e) {
                throw new RuntimeException("Failed to render button for 'system.admin.header.pageactions' web-section.", e);
            }
        }
    }
}

