/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.plugins.auditing.actions;

import com.atlassian.jira.auditing.AuditingRetentionPeriod;
import com.atlassian.jira.auditing.AuditingStore;
import com.atlassian.jira.component.ComponentAccessor;
import com.atlassian.jira.config.FeatureManager;
import com.atlassian.jira.plugins.auditing.actions.AbstractPage;
import com.atlassian.jira.plugins.auditing.actions.AuditingContext$;
import com.atlassian.jira.plugins.auditing.actions.Settings$;
import com.atlassian.jira.security.xsrf.RequiresXsrfCheck;
import com.atlassian.jira.util.BrowserUtils;
import com.atlassian.jira.util.json.JSONObject;
import com.atlassian.jira.web.action.ActionViewData;
import com.atlassian.jira.web.action.ActionViewDataMappings;
import com.atlassian.sal.api.websudo.WebSudoRequired;
import com.atlassian.webresource.api.assembler.PageBuilderService;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.util.List;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import scala.Function1;
import scala.Predef$;
import scala.Serializable;
import scala.collection.JavaConversions$;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@WebSudoRequired
@ScalaSignature(bytes="\u0006\u0001\u0005%x!B\u0001\u0003\u0011\u0003y\u0011\u0001C*fiRLgnZ:\u000b\u0005\r!\u0011aB1di&|gn\u001d\u0006\u0003\u000b\u0019\t\u0001\"Y;eSRLgn\u001a\u0006\u0003\u000f!\tq\u0001\u001d7vO&t7O\u0003\u0002\n\u0015\u0005!!.\u001b:b\u0015\tYA\"A\u0005bi2\f7o]5b]*\tQ\"A\u0002d_6\u001c\u0001\u0001\u0005\u0002\u0011#5\t!AB\u0003\u0013\u0005!\u00051C\u0001\u0005TKR$\u0018N\\4t'\r\tBC\u0007\t\u0003+ai\u0011A\u0006\u0006\u0002/\u0005)1oY1mC&\u0011\u0011D\u0006\u0002\u0007\u0003:L(+\u001a4\u0011\u0005UY\u0012B\u0001\u000f\u0017\u00051\u0019VM]5bY&T\u0018M\u00197f\u0011\u0015q\u0012\u0003\"\u0001 \u0003\u0019a\u0014N\\5u}Q\tq\u0002C\u0004\"#\t\u0007I\u0011\u0001\u0012\u00023!KE)R0F1R+%KT!M?\u0012K%+R\"U\u001fJKUiU\u000b\u0002GA\u0011A%K\u0007\u0002K)\u0011aeJ\u0001\u0005Y\u0006twMC\u0001)\u0003\u0011Q\u0017M^1\n\u0005)*#AB*ue&tw\r\u0003\u0004-#\u0001\u0006IaI\u0001\u001b\u0011&#UiX#Y)\u0016\u0013f*\u0011'`\t&\u0013Vi\u0011+P%&+5\u000b\t\u0005\b]E\t\t\u0011\"\u00030\u0003-\u0011X-\u00193SKN|GN^3\u0015\u0003A\u0002\"\u0001J\u0019\n\u0005I*#AB(cU\u0016\u001cGO\u0002\u0003\u0013\u0005\u0001!4CA\u001a6!\t\u0001b'\u0003\u00028\u0005\ta\u0011IY:ue\u0006\u001cG\u000fU1hK\")ad\rC\u0001sQ\t!\b\u0005\u0002\u0011g!9Ah\ra\u0001\n\u0003i\u0014a\u00039bO\u0016\u0014U/\u001b7eKJ,\u0012A\u0010\t\u0003\u007f\u0019k\u0011\u0001\u0011\u0006\u0003\u0003\n\u000b\u0011\"Y:tK6\u0014G.\u001a:\u000b\u0005\r#\u0015aA1qS*\u0011QIC\u0001\fo\u0016\u0014'/Z:pkJ\u001cW-\u0003\u0002H\u0001\n\u0011\u0002+Y4f\u0005VLG\u000eZ3s'\u0016\u0014h/[2f\u0011\u001dI5\u00071A\u0005\u0002)\u000bq\u0002]1hK\n+\u0018\u000e\u001c3fe~#S-\u001d\u000b\u0003\u0017:\u0003\"!\u0006'\n\u000553\"\u0001B+oSRDqa\u0014%\u0002\u0002\u0003\u0007a(A\u0002yIEBa!U\u001a!B\u0013q\u0014\u0001\u00049bO\u0016\u0014U/\u001b7eKJ\u0004\u0003F\u0001)T!\t!v,D\u0001V\u0015\t1v+\u0001\u0006b]:|G/\u0019;j_:T!\u0001W-\u0002\u000f\u0019\f7\r^8ss*\u0011!lW\u0001\u0006E\u0016\fgn\u001d\u0006\u00039v\u000bqb\u001d9sS:<gM]1nK^|'o\u001b\u0006\u0002=\u0006\u0019qN]4\n\u0005\u0001,&!C!vi><\u0018N]3e\u0011\u001d\u00117\u00071A\u0005\u0002\r\faBZ3biV\u0014X-T1oC\u001e,'/F\u0001e!\t)\u0007.D\u0001g\u0015\t9\u0007\"\u0001\u0004d_:4\u0017nZ\u0005\u0003S\u001a\u0014aBR3biV\u0014X-T1oC\u001e,'\u000fC\u0004lg\u0001\u0007I\u0011\u00017\u0002%\u0019,\u0017\r^;sK6\u000bg.Y4fe~#S-\u001d\u000b\u0003\u00176Dqa\u00146\u0002\u0002\u0003\u0007A\r\u0003\u0004pg\u0001\u0006K\u0001Z\u0001\u0010M\u0016\fG/\u001e:f\u001b\u0006t\u0017mZ3sA!\u0012an\u0015\u0005\beN\u0002\r\u0011\"\u0003t\u0003=\u0011X\r^3oi&|g\u000eU3sS>$W#\u0001;\u0011\u0005UDhBA\u000bw\u0013\t9h#\u0001\u0004Qe\u0016$WMZ\u0005\u0003UeT!a\u001e\f\t\u000fm\u001c\u0004\u0019!C\u0005y\u0006\u0019\"/\u001a;f]RLwN\u001c)fe&|Gm\u0018\u0013fcR\u00111* \u0005\b\u001fj\f\t\u00111\u0001u\u0011\u0019y8\u0007)Q\u0005i\u0006\u0001\"/\u001a;f]RLwN\u001c)fe&|G\r\t\u0005\n\u0003\u0007\u0019\u0004\u0019!C\u0005\u0003\u000b\tq\u0003[5eK\u0016CH/\u001a:oC2$\u0015N]3di>\u0014\u0018.Z:\u0016\u0005\u0005\u001d\u0001cA\u000b\u0002\n%\u0019\u00111\u0002\f\u0003\u000f\t{w\u000e\\3b]\"I\u0011qB\u001aA\u0002\u0013%\u0011\u0011C\u0001\u001cQ&$W-\u0012=uKJt\u0017\r\u001c#je\u0016\u001cGo\u001c:jKN|F%Z9\u0015\u0007-\u000b\u0019\u0002C\u0005P\u0003\u001b\t\t\u00111\u0001\u0002\b!A\u0011qC\u001a!B\u0013\t9!\u0001\riS\u0012,W\t\u001f;fe:\fG\u000eR5sK\u000e$xN]5fg\u0002Bq!a\u00074\t\u0003\ti\"\u0001\u0005e_V\u0003H-\u0019;f)\u0005!\b\u0006BA\r\u0003C\u0001B!a\t\u0002.5\u0011\u0011Q\u0005\u0006\u0005\u0003O\tI#\u0001\u0003ygJ4'bAA\u0016\u0011\u0005A1/Z2ve&$\u00180\u0003\u0003\u00020\u0005\u0015\"!\u0005*fcVL'/Z:YgJ47\t[3dW\"9\u00111G\u001a\u0005\n\u0005U\u0012A\u0004<bY&$\u0017\r^3GS\u0016dGm\u001d\u000b\u0002\u0017\"9\u0011\u0011H\u001a\u0005\n\u0005U\u0012\u0001D:bm\u0016\u001cV\r\u001e;j]\u001e\u001c\bbBA\u001fg\u0011%\u0011QG\u0001\u0018C\u0012$'+Z2pe\u0012\u001ch*^7cKJlUm]:bO\u0016Dq!!\u00114\t\u0013\t\u0019%\u0001\u000eok6\u0014WM](g\u000b:$(/[3t)>\u0014UMU3n_Z,G\r\u0006\u0003\u0002F\u0005-\u0003cA\u000b\u0002H%\u0019\u0011\u0011\n\f\u0003\t1{gn\u001a\u0005\t\u0003\u001b\ny\u00041\u0001\u0002P\u00051\u0001/\u001a:j_\u0012\u0004B!!\u0015\u0002V5\u0011\u00111\u000b\u0006\u0003\u000b!IA!a\u0016\u0002T\t9\u0012)\u001e3ji&twMU3uK:$\u0018n\u001c8QKJLw\u000e\u001a\u0005\b\u00037\u001aD\u0011AA/\u0003M9W\r\u001e*fi\u0016tG/[8o\u001fB$\u0018n\u001c8t+\t\ty\u0006\u0005\u0004\u0002b\u0005\u001d\u00141N\u0007\u0003\u0003GR1!!\u001a(\u0003\u0011)H/\u001b7\n\t\u0005%\u00141\r\u0002\u0005\u0019&\u001cH\u000f\u0005\u0004\u0002b\u00055D\u000fM\u0005\u0005\u0003_\n\u0019GA\u0002NCBD\u0003\"!\u0017\u0002t\u0005\r\u0015Q\u0011\t\u0005\u0003k\ny(\u0004\u0002\u0002x)!\u0011\u0011PA>\u0003\u0019\t7\r^5p]*\u0019\u0011Q\u0010\u0005\u0002\u0007],'-\u0003\u0003\u0002\u0002\u0006]$AD!di&|gNV5fo\u0012\u000bG/Y\u0001\u0006m\u0006dW/Z\u0011\u0003\u0003\u000f\u000bqa];dG\u0016\u001c8\u000fC\u0004\u0002\fN\"\t!!$\u00023\u001d,GoQ;se\u0016tGOU3uK:$\u0018n\u001c8QKJLw\u000eZ\u000b\u0003\u0003\u001fBq!!%4\t\u0003\t\u0019*\u0001\ntKR\u0014V\r^3oi&|g\u000eU3sS>$GcA&\u0002\u0016\"1!/a$A\u0002QDq!!'4\t\u0013\t)!\u0001\u0004jgB{7\u000f\u001e\u0005\b\u0003;\u001bD\u0011BA\u0003\u0003!I7/\u00169eCR,\u0007BBAQg\u0011\u00051/\u0001\bhKRlu\u000eZ5gS\u0016\u00148*Z=)\u0011\u0005}\u00151OAB\u0003\u000bCa!a*4\t\u0003\u0019\u0018aC4fi\u0006#H\u000eV8lK:D\u0003\"!*\u0002t\u0005\r\u0015Q\u0011\u0005\b\u0003[\u001bD\u0011AAX\u0003-9W\r\u001e,jK^$\u0015\r^1\u0016\u0005\u0005-\u0004\u0006CAV\u0003g\u000b\u0019)!/\u0011\t\u0005U\u0014QW\u0005\u0005\u0003o\u000b9H\u0001\fBGRLwN\u001c,jK^$\u0015\r^1NCB\u0004\u0018N\\4tY\t\t)\t\u0003\u0004\u0002>N\"\ta]\u0001*O\u0016$(+\u001a;f]RLwN\u001c)fe&|GmV1s]&tw\r\u0016:b]Nd\u0017\r^5p]NT5o\u001c8)\u0011\u0005m\u00161OAB\u0003\u000bCa!a14\t\u0003\u0019\u0018!F4fi\u000e+(O]3oiB+'/[8e-\u0006dW/\u001a\u0015\t\u0003\u0003\f\u0019(a!\u0002\u0006\"9\u0011\u0011Z\u001a\u0005\u0002\u0005\u0015\u0011AG4fi\"KG-Z#yi\u0016\u0014h.\u00197ESJ,7\r^8sS\u0016\u001c\b\u0006CAd\u0003g\n\u0019)!\"\t\u000f\u0005=7\u0007\"\u0001\u0002R\u0006Q2/\u001a;IS\u0012,W\t\u001f;fe:\fG\u000eR5sK\u000e$xN]5fgR\u00191*a5\t\u0011\u0005\r\u0011Q\u001aa\u0001\u0003\u000fA3aMAl!\u0011\tI.!:\u000e\u0005\u0005m'\u0002BAo\u0003?\fqa^3cgV$wNC\u0002D\u0003CT1!a9\u000b\u0003\r\u0019\u0018\r\\\u0005\u0005\u0003O\fYNA\bXK\n\u001cV\u000fZ8SKF,\u0018N]3e\u0001")
public class Settings
extends AbstractPage {
    @Autowired
    private PageBuilderService pageBuilder = null;
    @Autowired
    private FeatureManager featureManager = null;
    private String com$atlassian$jira$plugins$auditing$actions$Settings$$retentionPeriod = null;
    private boolean hideExternalDirectories = false;

    public static String HIDE_EXTERNAL_DIRECTORIES() {
        return Settings$.MODULE$.HIDE_EXTERNAL_DIRECTORIES();
    }

    public PageBuilderService pageBuilder() {
        return this.pageBuilder;
    }

    public void pageBuilder_$eq(PageBuilderService x$1) {
        this.pageBuilder = x$1;
    }

    public FeatureManager featureManager() {
        return this.featureManager;
    }

    public void featureManager_$eq(FeatureManager x$1) {
        this.featureManager = x$1;
    }

    public String com$atlassian$jira$plugins$auditing$actions$Settings$$retentionPeriod() {
        return this.com$atlassian$jira$plugins$auditing$actions$Settings$$retentionPeriod;
    }

    private void com$atlassian$jira$plugins$auditing$actions$Settings$$retentionPeriod_$eq(String x$1) {
        this.com$atlassian$jira$plugins$auditing$actions$Settings$$retentionPeriod = x$1;
    }

    private boolean hideExternalDirectories() {
        return this.hideExternalDirectories;
    }

    private void hideExternalDirectories_$eq(boolean x$1) {
        this.hideExternalDirectories = x$1;
    }

    @RequiresXsrfCheck
    public String doUpdate() {
        this.pageBuilder().assembler().resources().requireWebResource(new StringBuilder().append((Object)AuditingContext$.MODULE$.PLUGIN_KEY()).append((Object)":auditing-plugin-common-resources").toString());
        this.validateFields();
        if (this.hasAnyErrors()) {
            return "success";
        }
        this.addRecordsNumberMessage();
        this.saveSettings();
        return this.returnComplete();
    }

    private void validateFields() {
        AuditingRetentionPeriod periodObj = AuditingRetentionPeriod.getByValue((String)this.com$atlassian$jira$plugins$auditing$actions$Settings$$retentionPeriod());
        if (!AuditingRetentionPeriod.getValidValues().contains(periodObj)) {
            this.addError("retentionPeriod", this.getText("jap.retention.period.error.message.invalid"));
        }
    }

    private void saveSettings() {
        AuditingRetentionPeriod periodObj = AuditingRetentionPeriod.getByValue((String)this.com$atlassian$jira$plugins$auditing$actions$Settings$$retentionPeriod());
        this.getApplicationProperties().setString("jira.option.auditing.log.retention.period.in.months", periodObj.getValue());
        this.getApplicationProperties().setString("jira.option.auditing.log.retention.period.last.change.timestamp", String.valueOf(System.currentTimeMillis() / 1000L));
        this.getApplicationProperties().setOption(Settings$.MODULE$.HIDE_EXTERNAL_DIRECTORIES(), this.hideExternalDirectories());
    }

    private void addRecordsNumberMessage() {
        long entriesToBeRemoved;
        AuditingRetentionPeriod periodObj = AuditingRetentionPeriod.getByValue((String)this.com$atlassian$jira$plugins$auditing$actions$Settings$$retentionPeriod());
        if (!periodObj.isUnlimited() && (entriesToBeRemoved = this.numberOfEntriesToBeRemoved(periodObj)) > 0L) {
            String monthsText = this.getText(new StringBuilder().append((Object)periodObj.getNameI18nKey()).append((Object)".text").toString());
            String messageText = this.getText("jap.settings.global.message.content", monthsText, ((Object)BoxesRunTime.boxToLong((long)entriesToBeRemoved)).toString());
            this.addMessageToResponse(messageText, "placeholder", true, "placeholder");
        }
    }

    private long numberOfEntriesToBeRemoved(AuditingRetentionPeriod period) {
        return ((AuditingStore)ComponentAccessor.getComponent(AuditingStore.class)).countRecordsOlderThan(period.monthsIntoPast().getMillis());
    }

    @ActionViewData(value="success")
    public List<Map<String, Object>> getRetentionOptions() {
        AuditingRetentionPeriod current = this.getCurrentRetentionPeriod();
        List periods = AuditingRetentionPeriod.getValidValues();
        ImmutableList.Builder builder = ImmutableList.builder();
        JavaConversions$.MODULE$.asScalaBuffer(periods).foreach((Function1)new Serializable(this, current, builder){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ Settings $outer;
            private final AuditingRetentionPeriod current$1;
            private final ImmutableList.Builder builder$1;

            public final ImmutableList.Builder<Map<String, Object>> apply(AuditingRetentionPeriod period) {
                ImmutableMap.Builder mapBuilder = ImmutableMap.builder();
                Boolean selected = this.$outer.com$atlassian$jira$plugins$auditing$actions$Settings$$isPost() ? Predef$.MODULE$.boolean2Boolean(period.getValue().equals(this.$outer.com$atlassian$jira$plugins$auditing$actions$Settings$$retentionPeriod())) : Predef$.MODULE$.boolean2Boolean(period.getValue().equals(this.current$1.getValue()));
                mapBuilder.put((Object)"value", (Object)period.getValue());
                mapBuilder.put((Object)"text", (Object)this.$outer.getText(period.getNameI18nKey()));
                mapBuilder.put((Object)"selected", (Object)selected);
                return this.builder$1.add((Object)mapBuilder.build());
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
                this.current$1 = current$1;
                this.builder$1 = builder$1;
            }
        });
        return builder.build();
    }

    public AuditingRetentionPeriod getCurrentRetentionPeriod() {
        String period = this.getApplicationProperties().getDefaultBackedString("jira.option.auditing.log.retention.period.in.months");
        return AuditingRetentionPeriod.getByValue((String)period);
    }

    public void setRetentionPeriod(String retentionPeriod) {
        this.com$atlassian$jira$plugins$auditing$actions$Settings$$retentionPeriod_$eq(retentionPeriod);
    }

    public boolean com$atlassian$jira$plugins$auditing$actions$Settings$$isPost() {
        return this.getHttpRequest().getMethod().equals("POST");
    }

    private boolean isUpdate() {
        return "update".equals(this.getCommandName());
    }

    @ActionViewData(value="success")
    public String getModifierKey() {
        return BrowserUtils.getModifierKey();
    }

    @ActionViewData(value="success")
    public String getAtlToken() {
        return this.getXsrfToken();
    }

    @ActionViewDataMappings(value={"success"})
    public Map<String, Object> getViewData() {
        return ImmutableMap.of((Object)"errorTexts", (Object)this.getErrors());
    }

    @ActionViewData(value="success")
    public String getRetentionPeriodWarningTranslationsJson() {
        JSONObject jsonObject = new JSONObject();
        List periods = AuditingRetentionPeriod.getValidValues();
        JavaConversions$.MODULE$.asScalaBuffer(periods).withFilter((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final boolean apply(AuditingRetentionPeriod period) {
                return !period.isUnlimited();
            }
        }).foreach((Function1)new Serializable(this, jsonObject){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ Settings $outer;
            private final JSONObject jsonObject$1;

            public final JSONObject apply(AuditingRetentionPeriod period) {
                String monthsText = this.$outer.getText(new StringBuilder().append((Object)period.getNameI18nKey()).append((Object)".text").toString());
                return this.jsonObject$1.put(period.getValue(), (Object)this.$outer.getText("jap.retention.period.warning.content", monthsText));
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
                this.jsonObject$1 = jsonObject$1;
            }
        });
        return jsonObject.toString();
    }

    @ActionViewData(value="success")
    public String getCurrentPeriodValue() {
        return this.getCurrentRetentionPeriod().getValue();
    }

    @ActionViewData(value="success")
    public boolean getHideExternalDirectories() {
        return this.getApplicationProperties().getOption(Settings$.MODULE$.HIDE_EXTERNAL_DIRECTORIES());
    }

    public void setHideExternalDirectories(boolean hideExternalDirectories) {
        this.hideExternalDirectories_$eq(hideExternalDirectories);
    }

    public Settings() {
        super("Settings");
    }
}

