/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.crowd.plugin.rest.service.resource.directory;

import com.atlassian.crowd.exception.DirectoryNotFoundException;
import com.atlassian.crowd.exception.OperationFailedException;
import com.atlassian.crowd.plugin.rest.entity.CrowdConnectionTestEntity;
import com.atlassian.crowd.plugin.rest.entity.LdapConnectionTestEntity;
import com.atlassian.crowd.plugin.rest.entity.LdapSearchTestEntity;
import com.atlassian.crowd.plugin.rest.service.controller.DirectoryController;
import com.atlassian.crowd.plugin.rest.service.resource.directory.DirectoryTestFailedException;
import javax.ws.rs.Consumes;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Response;

@Path(value="directory")
@Consumes(value={"application/xml", "application/json"})
@Produces(value={"application/xml", "application/json"})
public class DirectoryResource {
    private final DirectoryController directoryController;

    public DirectoryResource(DirectoryController directoryController) {
        this.directoryController = directoryController;
    }

    @POST
    @Path(value="testldap")
    public Response testLdapConnection(LdapConnectionTestEntity connectionTestData) throws OperationFailedException, DirectoryTestFailedException {
        this.directoryController.testLdapConnection(connectionTestData);
        return Response.noContent().build();
    }

    @POST
    @Path(value="testldap/{id}")
    public Response testLdapConnection(@PathParam(value="id") Long id, LdapConnectionTestEntity connectionTestData) throws DirectoryNotFoundException, OperationFailedException, DirectoryTestFailedException {
        this.directoryController.testLdapConnection(connectionTestData, id);
        return Response.noContent().build();
    }

    @POST
    @Path(value="testcrowd")
    public Response testCrowdConnection(CrowdConnectionTestEntity connectionTestData) throws OperationFailedException, DirectoryTestFailedException {
        this.directoryController.testCrowdConnection(connectionTestData);
        return Response.noContent().build();
    }

    @POST
    @Path(value="testcrowd/{id}")
    public Response testCrowdConnection(@PathParam(value="id") Long id, CrowdConnectionTestEntity connectionTestData) throws DirectoryNotFoundException, OperationFailedException, DirectoryTestFailedException {
        this.directoryController.testCrowdConnection(connectionTestData, id);
        return Response.noContent().build();
    }

    @POST
    @Path(value="testsearch")
    public Response testSearch(LdapSearchTestEntity ldapConfiguration) throws OperationFailedException, DirectoryTestFailedException {
        this.directoryController.testLdapSearch(ldapConfiguration);
        return Response.noContent().build();
    }

    @POST
    @Path(value="testsearch/{id}")
    public Response testSearch(LdapSearchTestEntity ldapConfiguration, @PathParam(value="id") Long id) throws OperationFailedException, DirectoryNotFoundException, DirectoryTestFailedException {
        this.directoryController.testLdapSearch(ldapConfiguration, id);
        return Response.noContent().build();
    }
}

