/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.renderer.v2.macro.code.formatter;

import com.atlassian.renderer.v2.macro.code.formatter.AbstractFormatter;

public class SwiftFormatter
extends AbstractFormatter {
    private static final String KEYWORDS = SwiftFormatter.individualWords(new String[]{"Any", "Protocol", "Self", "Type", "_", "as", "associatedtype", "associativity", "break", "case", "catch", "class[^=]", "continue", "convenience", "default", "defer", "deinit", "didSet", "do", "dynamic", "[^#]else", "enum", "extension", "fallthrough", "false", "fileprivate", "final", "for", "func", "get", "guard", "[^#]if", "import", "in", "indirect", "infix", "init", "inout", "internal", "is", "lazy", "left", "let", "mutating", "nil", "none", "nonmutating", "open", "operator", "optional", "override", "postfix", "precedence", "prefix", "private", "protocol", "public", "repeat", "required", "rethrows", "return", "right", "self", "set", "static", "struct", "subscript", "super", "switch", "throw", "throws", "true", "try", "typealias", "unowned", "var", "weak", "where", "while", "willSet"});
    private static final String ATS_AND_HASHES = "(#available|#colorLiteral|#column|#else|#elseif|#endif|#file|#fileLiteral|#function|#if|#imageLiteral|#line|#selector|#sourceLocation|@objc)";
    private static final String OBJECTS = SwiftFormatter.individualWords(new String[]{"AbsoluteValuable", "AnyBidirectionalCollection", "AnyCollection", "AnyHashable", "AnyIndex", "AnyIterator", "AnyObject", "AnyRandomAccessCollection", "AnySequence", "Arithmetic", "ArithmeticOverflow", "Array", "ArraySlice", "AutoreleasingUnsafeMutablePointer", "BidirectionalCollection", "BidirectionalSlice", "BinaryFloatingPoint", "BinaryInteger", "BitwiseOperations", "Bool", "CVaListPointer", "CVarArg", "Character", "ClosedRange", "ClosedRangeIndex", "ClosedRangeIterator", "Collection", "CollectionOfOne", "CommandLine", "Comparable", "ContiguousArray", "CountableClosedRange", "CountableRange", "CustomDebugStringConvertible", "CustomLeafReflectable", "CustomPlaygroundQuickLookable", "CustomReflectable", "CustomStringConvertible", "DefaultBidirectionalIndices", "DefaultIndices", "DefaultRandomAccessIndices", "Dictionary", "DictionaryIterator", "DictionaryLiteral", "Double", "EmptyCollection", "EmptyIterator", "EnumeratedIterator", "EnumeratedSequence", "Equatable", "Error", "ExpressibleByArrayLiteral", "ExpressibleByBooleanLiteral", "ExpressibleByDictionaryLiteral", "ExpressibleByExtendedGraphemeClusterLiteral", "ExpressibleByFloatLiteral", "ExpressibleByIntegerLiteral", "ExpressibleByNilLiteral", "ExpressibleByStringLiteral", "ExpressibleByUnicodeScalarLiteral", "FixedWidthInteger", "FlattenBidirectionalCollection", "FlattenBidirectionalCollectionIndex", "FlattenCollection", "FlattenCollectionIndex", "FlattenIterator", "FlattenSequence", "Float", "Float80", "FloatingPoint", "FloatingPointClassification", "FloatingPointRoundingRule", "FloatingPointSign", "Hashable", "ImplicitlyUnwrappedOptional", "IndexingIterator", "Int", "Int16", "Int32", "Int64", "Int8", "Integer", "IntegerArithmetic", "IteratorOverOne", "IteratorProtocol", "IteratorSequence", "JoinedIterator", "JoinedSequence", "LazyBidirectionalCollection", "LazyCollection", "LazyCollectionProtocol", "LazyDropWhileBidirectionalCollection", "LazyDropWhileCollection", "LazyDropWhileIndex", "LazyDropWhileIterator", "LazyDropWhileSequence", "LazyFilterBidirectionalCollection", "LazyFilterCollection", "LazyFilterIndex", "LazyFilterIterator", "LazyFilterSequence", "LazyMapBidirectionalCollection", "LazyMapCollection", "LazyMapIterator", "LazyMapRandomAccessCollection", "LazyMapSequence", "LazyPrefixWhileBidirectionalCollection", "LazyPrefixWhileCollection", "LazyPrefixWhileIndex", "LazyPrefixWhileIterator", "LazyPrefixWhileSequence", "LazyRandomAccessCollection", "LazySequence", "LazySequenceProtocol", "LosslessStringConvertible", "ManagedBuffer", "ManagedBufferPointer", "MemoryLayout", "Mirror", "Mirror.AncestorRepresentation", "Mirror.DisplayStyle", "MirrorPath", "MutableBidirectionalSlice", "MutableCollection", "MutableRandomAccessSlice", "MutableRangeReplaceableBidirectionalSlice", "MutableRangeReplaceableRandomAccessSlice", "MutableRangeReplaceableSlice", "MutableSlice", "Never", "ObjectIdentifier", "OpaquePointer", "OptionSet", "Optional", "PlaygroundQuickLook", "RandomAccessCollection", "RandomAccessSlice", "Range", "RangeReplaceableBidirectionalSlice", "RangeReplaceableCollection", "RangeReplaceableRandomAccessSlice", "RangeReplaceableSlice", "RawRepresentable", "Repeated", "ReversedCollection", "ReversedIndex", "ReversedRandomAccessCollection", "ReversedRandomAccessIndex", "Sequence", "Set", "SetAlgebra", "SetIterator", "SignedArithmetic", "SignedInteger", "SignedInteger_", "SignedNumber", "Slice", "StaticString", "StrideThrough", "StrideThroughIterator", "StrideTo", "StrideToIterator", "Strideable", "String", "TextOutputStream", "TextOutputStreamable", "UInt", "UInt16", "UInt32", "UInt64", "UInt8", "UTF16", "UTF32", "UTF8", "UnfoldSequence", "UnicodeCodec", "UnicodeDecodingResult", "UnicodeScalar", "Unmanaged", "UnsafeBufferPointer", "UnsafeBufferPointerIterator", "UnsafeMutableBufferPointer", "UnsafeMutablePointer", "UnsafeMutableRawBufferPointer", "UnsafeMutableRawPointer", "UnsafePointer", "UnsafeRawBufferPointer", "UnsafeRawPointer", "UnsignedInteger", "UnsignedInteger_", "Zip2Iterator", "Zip2Sequence", "_Incrementable", "NS[a-zA-Z]+", "UI[a-zA-Z]+", "CF[a-zA-Z]+", "CG[a-zA-Z]+", "CI[a-zA-Z]+"});
    private static final String[] SUPPORTED_LANGUAGES = new String[]{"swift"};

    public SwiftFormatter() {
        this.addReplacement("(\"|\\&quot;)(.+?)(?<!(\"|\\&quot;))(\"|\\&quot;)", "<span class=\"code-quote-red\">$1$2$4</span>");
        this.addReplacement("('|\\&apos;)(.+?)(?<!('|\\&apos;))('|\\&apos;)", "<span class=\"code-quote-red\">$1$2$4</span>");
        this.addReplacement("//(.*?)($|\r?\n)", "<span class=\"code-comment\">$0</span>");
        this.addReplacement("/\\*(.*?)\\*/", "<span class=\"code-comment\">$0</span>");
        this.addReplacement(OBJECTS, "<span class=\"code-object\">$1</span>");
        this.addReplacement(KEYWORDS, "<span class=\"code-keyword\">$1</span>");
        this.addReplacement(ATS_AND_HASHES, "<span class=\"code-keyword\">$1</span>");
    }

    @Override
    public String[] getSupportedLanguages() {
        return SUPPORTED_LANGUAGES;
    }
}

