/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.renderer.v2.macro.code.formatter;

import com.atlassian.renderer.v2.macro.code.formatter.AbstractFormatter;

public class AdaFormatter
extends AbstractFormatter {
    private static final String KEYWORDS = AdaFormatter.individualWords(new String[]{"abort", "abs", "abstract", "accept", "access", "aliased", "all", "and", "array", "at", "begin", "body", "case", "constant", "declare", "delay", "delta", "digits", "do", "else", "elsif", "end", "entry", "exception", "exit", "FALSE", "for", "function", "generic", "goto", "if", "in", "interface", "is", "limited", "loop", "mod", "new", "not", "null", "of", "or", "others", "out", "overriding", "package", "pragma", "private", "procedure", "protected", "raise", "range", "record", "rem", "renames", "requeue", "return", "reverse", "select", "separate", "some", "subtype", "synchronized", "tagged", "task", "terminate", "then", "TRUE", "type", "until", "use", "when", "while", "with", "xor"});
    private static final String OBJECTS = AdaFormatter.individualWords(new String[]{"Boolean", "Character", "Decimal", "Fixed", "Float", "Integer", "Long_Integer", "Long_Long_Integer", "Short_Integer", "String", "Wide_Character"});
    private static final String[] SUPPORTED_LANGUAGES = new String[]{"ada"};

    public AdaFormatter() {
        this.addReplacement("(\"|\\&quot;)(.+?)(?<!(\"|\\&quot;))(\"|\\&quot;)", "<span class=\"code-quote\">$1$2$4</span>");
        this.addReplacement("('|\\&apos;)(.+?)(?<!('|\\&apos;))('|\\&apos;)", "<span class=\"code-quote\">$1$2$4</span>");
        this.addReplacement("--(.*?)($|\r?\n)", "<span class=\"code-comment\">$0</span>");
        this.addReplacement(OBJECTS, "<span class=\"code-object\">$1</span>");
        this.addReplacement(KEYWORDS, "<span class=\"code-keyword\">$1</span>");
    }

    @Override
    public String[] getSupportedLanguages() {
        return SUPPORTED_LANGUAGES;
    }
}

