/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.renderer.v2.macro.code.formatter;

import com.atlassian.renderer.v2.Replacer;
import com.atlassian.renderer.v2.macro.code.SourceCodeFormatter;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Pattern;
import org.apache.commons.lang.StringUtils;

public abstract class AbstractFormatter
implements SourceCodeFormatter {
    public static final String DQUOTES = "(\"|\\&quot;)(.+?)(?<!(\"|\\&quot;))(\"|\\&quot;)";
    public static final String SQUOTES = "('|\\&apos;)(.+?)(?<!('|\\&apos;))('|\\&apos;)";
    public static final String BQUOTES = "(`|\\&#96;)(.+?)(?<!(`|\\&#96;))(`|\\&#96;)";
    public static final String SLASH_COMMENTS = "//(.*?)($|\r?\n)";
    public static final String DASH_COMMENTS = "--(.*?)($|\r?\n)";
    public static final String HASH_COMMENTS = "#(.*?)($|\r?\n)";
    public static final String PERCENT_COMMENTS = "%(.*?)($|\r?\n)";
    public static final String C_COMMENTS = "/\\*(.*?)\\*/";
    public static final String CLASS = "class[^=]";
    public static final String QUOTES_REPLACEMENT = "<span class=\"code-quote\">$1$2$4</span>";
    public static final String QUOTES_REPLACEMENT_RED = "<span class=\"code-quote-red\">$1$2$4</span>";
    public static final String COMMENTS_REPLACEMENT = "<span class=\"code-comment\">$0</span>";
    public static final String KEYWORD_REPLACEMENT = "<span class=\"code-keyword\">$1</span>";
    public static final String OBJECT_REPLACEMENT = "<span class=\"code-object\">$1</span>";
    protected List<Replacer> replacers = new ArrayList<Replacer>();

    protected static final String individualWords(String[] words) {
        String wordsRegex = StringUtils.join((Object[])words, (String)"|");
        return "\\b(" + wordsRegex + ")\\b";
    }

    protected void addReplacement(String pattern, String replacement) {
        this.replacers.add(new Replacer(Pattern.compile(pattern), replacement));
    }

    @Override
    public String format(String code, String language) {
        for (Replacer replacer : this.replacers) {
            code = replacer.replaceAllSkippingConstantsCheck(code);
        }
        return code;
    }
}

