/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.plugins.workflow.sharing.util;

import java.io.Closeable;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;

public class LimitedInputStream
extends FilterInputStream
implements Closeable {
    private final long maxSize;
    private long currentSize;

    public LimitedInputStream(InputStream stream, long maxSize) {
        super(stream);
        this.maxSize = maxSize;
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        this.checkSize();
        int size = super.read(b, off, len);
        if (size > 0) {
            this.currentSize += (long)size;
            this.checkSize();
        }
        return size;
    }

    @Override
    public int read() throws IOException {
        this.checkSize();
        int data = super.read();
        if (data >= 0) {
            ++this.currentSize;
            this.checkSize();
        }
        return data;
    }

    @Override
    public long skip(long n) throws IOException {
        this.checkSize();
        long skip = super.skip(n);
        this.currentSize += skip;
        this.checkSize();
        return skip;
    }

    private void checkSize() throws IOException {
        if (this.currentSize > this.maxSize) {
            throw new StreamTooBigException(this.currentSize, this.maxSize);
        }
    }

    public static class StreamTooBigException
    extends IOException {
        private final long size;
        private final long maxSize;

        public StreamTooBigException(long size, long maxSize) {
            this.size = size;
            this.maxSize = maxSize;
        }

        public long getSize() {
            return this.size;
        }

        public long getMaxSize() {
            return this.maxSize;
        }
    }
}

