/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.plugins.workflow.sharing.util;

import com.atlassian.jira.plugins.workflow.sharing.util.HttpResult;
import com.atlassian.marketplace.client.HttpConfiguration;
import java.io.IOException;
import org.apache.http.HttpHost;
import org.apache.http.HttpResponse;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.Credentials;
import org.apache.http.auth.NTCredentials;
import org.apache.http.auth.UsernamePasswordCredentials;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.conn.ClientConnectionManager;
import org.apache.http.impl.client.DefaultHttpClient;
import org.apache.http.impl.conn.BasicClientConnectionManager;
import org.apache.http.params.BasicHttpParams;
import org.apache.http.params.HttpParams;

public class HttpUtils {
    public static HttpResult execute(HttpRequestBase method) throws IOException {
        BasicClientConnectionManager httpConnectionManager = new BasicClientConnectionManager();
        BasicHttpParams httpParams = new BasicHttpParams();
        httpParams.setIntParameter("http.connection.timeout", 60000);
        httpParams.setIntParameter("http.socket.timeout", 60000);
        httpParams.setParameter("http.protocol.cookie-policy", (Object)"ignoreCookies");
        DefaultHttpClient httpClient = new DefaultHttpClient((ClientConnectionManager)httpConnectionManager, (HttpParams)httpParams);
        HttpUtils.configureProxy(httpClient);
        return new HttpResult((HttpResponse)httpClient.execute((HttpUriRequest)method), (ClientConnectionManager)httpConnectionManager, method);
    }

    private static void configureProxy(DefaultHttpClient httpClient) {
        String host = System.getProperty("http.proxyHost");
        if (host != null) {
            Integer port = Integer.getInteger("http.proxyPort", 80);
            httpClient.getParams().setParameter("http.route.default-proxy", (Object)new HttpHost(host, port.intValue()));
            String proxyUser = System.getProperty("http.proxyUser");
            if (proxyUser != null) {
                UsernamePasswordCredentials proxyCredentials;
                String proxyPassword = System.getProperty("http.proxyPassword");
                String method = System.getProperty("http.proxyAuth", "basic");
                String domain = System.getProperty("http.proxyNtlmDomain", "");
                String workstation = System.getProperty("http.proxyNtlmWorkstation", "");
                AuthScope proxyAuthScope = new AuthScope(host, port.intValue());
                switch (HttpConfiguration.ProxyConfiguration.AuthMethod.valueOf((String)method.trim().toUpperCase())) {
                    case NTLM: {
                        proxyCredentials = new NTCredentials(proxyUser, proxyPassword, workstation == null ? "" : workstation, domain == null ? "" : domain);
                        break;
                    }
                    default: {
                        proxyCredentials = new UsernamePasswordCredentials(proxyUser, proxyPassword);
                    }
                }
                httpClient.getCredentialsProvider().setCredentials(proxyAuthScope, (Credentials)proxyCredentials);
            }
        }
    }
}

