/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.plugins.workflow.sharing.model;

import com.atlassian.jira.plugins.workflow.sharing.model.ScreenTabInfo;
import com.google.common.base.Function;
import java.io.Serializable;
import java.util.Comparator;
import java.util.List;
import org.apache.commons.lang.builder.EqualsBuilder;
import org.apache.commons.lang.builder.HashCodeBuilder;
import org.codehaus.jackson.annotate.JsonCreator;
import org.codehaus.jackson.annotate.JsonProperty;
import org.codehaus.jackson.type.TypeReference;

public class ScreenInfo
implements Serializable {
    private static final long serialVersionUID = 5428739985963548119L;
    public static final TypeReference<List<ScreenInfo>> LIST_TYPE = new TypeReference<List<ScreenInfo>>(){};
    public static Function<ScreenInfo, Long> GET_ORIGINAL_ID = new Function<ScreenInfo, Long>(){

        public Long apply(ScreenInfo input) {
            return input.getOriginalId();
        }
    };
    public static Comparator<ScreenInfo> ORDER_NAME = new Comparator<ScreenInfo>(){

        @Override
        public int compare(ScreenInfo o1, ScreenInfo o2) {
            return o1.getName().compareToIgnoreCase(o2.getName());
        }
    };
    private final Long originalId;
    private final String name;
    private final String description;
    private final List<ScreenTabInfo> tabs;

    @JsonCreator
    public ScreenInfo(@JsonProperty(value="originalId") Long originalId, @JsonProperty(value="name") String name, @JsonProperty(value="description") String description, @JsonProperty(value="tabs") List<ScreenTabInfo> tabs) {
        this.originalId = originalId;
        this.name = name;
        this.description = description;
        this.tabs = tabs;
    }

    public Long getOriginalId() {
        return this.originalId;
    }

    public String getName() {
        return this.name;
    }

    public String getDescription() {
        return this.description;
    }

    public List<ScreenTabInfo> getTabs() {
        return this.tabs;
    }

    public int hashCode() {
        return new HashCodeBuilder().append((Object)this.originalId).append((Object)this.name).toHashCode();
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof ScreenInfo)) {
            return false;
        }
        ScreenInfo info = (ScreenInfo)obj;
        return new EqualsBuilder().append((Object)this.getOriginalId(), (Object)info.getOriginalId()).append((Object)this.getName(), (Object)info.getName()).isEquals();
    }

    public String toString() {
        return "ScreenInfo name:" + this.name;
    }
}

