/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.plugins.workflow.sharing.importer.rest;

import com.atlassian.jira.plugins.workflow.sharing.importer.rest.PluginHolder;
import com.atlassian.jira.plugins.workflow.sharing.pac.JWSPacClient;
import com.atlassian.jira.plugins.workflow.sharing.pac.JWSPacClientFactory;
import com.atlassian.marketplace.client.api.Page;
import com.atlassian.marketplace.client.api.PageReference;
import com.atlassian.marketplace.client.model.Plugin;
import com.atlassian.marketplace.client.model.PluginSummary;
import com.atlassian.upm.api.util.Option;
import java.util.ArrayList;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Response;
import org.apache.commons.lang3.StringUtils;

@Path(value="/workflowbundles")
public class WorkflowBundlesResource {
    private final JWSPacClientFactory clientFactory;

    public WorkflowBundlesResource(JWSPacClientFactory clientFactory) {
        this.clientFactory = clientFactory;
    }

    @Path(value="/summary/{offset}")
    @GET
    @Produces(value={"application/json"})
    public Response getWorkflowBundles(@PathParam(value="offset") Integer offset, @QueryParam(value="filter") String filter) {
        Option parsedFilter = StringUtils.isNotBlank((CharSequence)filter) ? Option.some((Object)filter) : Option.none();
        JWSPacClient client = this.clientFactory.getPacClient();
        Page<PluginSummary> pluginSummariesPage = client.getWorkflowBundleListByFilter((Option<String>)parsedFilter, offset);
        ArrayList<PluginSummary> plugins = new ArrayList<PluginSummary>();
        for (PluginSummary pluginSummary : pluginSummariesPage) {
            plugins.add(pluginSummary);
        }
        Option nextPage = pluginSummariesPage.getNext();
        Integer nextOffset = -1;
        if (nextPage.isDefined()) {
            nextOffset = ((PageReference)nextPage.get()).getOffset();
        }
        return Response.ok((Object)new PluginHolder(plugins, nextOffset)).build();
    }

    @Path(value="/details/{pluginKey}")
    @GET
    @Produces(value={"application/json"})
    public Response getBundleDetails(@PathParam(value="pluginKey") String pluginKey) {
        JWSPacClient client = this.clientFactory.getPacClient();
        Plugin plugin = client.getWorkflowBundleDetails(pluginKey);
        if (null != plugin) {
            return Response.ok((Object)plugin).build();
        }
        return Response.ok((Object)"{}").build();
    }
}

