/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.plugins.workflow.sharing.importer.component;

import com.atlassian.jira.bc.ServiceOutcome;
import com.atlassian.jira.bc.ServiceResult;
import com.atlassian.jira.bc.config.StatusService;
import com.atlassian.jira.config.ConstantsManager;
import com.atlassian.jira.issue.status.SimpleStatus;
import com.atlassian.jira.issue.status.SimpleStatusImpl;
import com.atlassian.jira.issue.status.Status;
import com.atlassian.jira.issue.status.category.StatusCategory;
import com.atlassian.jira.issue.status.category.StatusCategoryImpl;
import com.atlassian.jira.plugins.workflow.sharing.importer.StatusMapping;
import com.atlassian.jira.plugins.workflow.sharing.importer.ValidNameGenerator;
import com.atlassian.jira.plugins.workflow.sharing.importer.component.WorkflowStatusHelper;
import com.atlassian.jira.plugins.workflow.sharing.model.StatusInfo;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.jira.workflow.WorkflowUtil;
import com.atlassian.plugin.spring.scanner.annotation.export.ExportAsService;
import com.atlassian.sal.api.message.I18nResolver;
import com.google.common.base.Function;
import com.google.common.base.Predicate;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import com.google.common.collect.Maps;
import com.opensymphony.workflow.FactoryException;
import com.opensymphony.workflow.loader.StepDescriptor;
import com.opensymphony.workflow.loader.WorkflowDescriptor;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@ExportAsService
@Component
public class WorkflowStatusHelperImpl
implements WorkflowStatusHelper {
    private final ConstantsManager constantsManager;
    private final I18nResolver i18n;
    private final ValidNameGenerator validNameGenerator;
    private final JiraAuthenticationContext authenticationContext;
    private final StatusService statusService;

    @Autowired
    public WorkflowStatusHelperImpl(ConstantsManager constantsManager, I18nResolver i18n, ValidNameGenerator validNameGenerator, JiraAuthenticationContext authenticationContext, StatusService statusService) {
        this.constantsManager = constantsManager;
        this.i18n = i18n;
        this.validNameGenerator = validNameGenerator;
        this.authenticationContext = authenticationContext;
        this.statusService = statusService;
    }

    @Override
    public Map<String, StatusMapping> getStatusHolders(String xml) {
        return this.getStatusHolders(xml, null);
    }

    @Override
    public Map<String, StatusMapping> getStatusHolders(String xml, List<StatusInfo> statusInfo) {
        Collection jiraStatuses = this.constantsManager.getStatusObjects();
        HashMap statusInfoMap = Maps.newHashMap();
        if (null != statusInfo) {
            for (StatusInfo info : statusInfo) {
                statusInfoMap.put(info.getOriginalId(), info);
            }
        }
        HashMap holders = Maps.newHashMap();
        WorkflowDescriptor descriptor = this.getWorkflowDescriptor(xml);
        List steps = descriptor.getSteps();
        Long defaultStatusCategoryId = StatusCategoryImpl.getDefault().getId();
        for (StepDescriptor step : steps) {
            StatusMapping mapping;
            if (step.getMetaAttributes() == null || !step.getMetaAttributes().containsKey("jira.status.id")) continue;
            String statusId = (String)step.getMetaAttributes().get("jira.status.id");
            Status found = (Status)Iterables.find((Iterable)jiraStatuses, (Predicate)new StatusNamePredicate(step.getName()), null);
            if (found != null) {
                Long statusCategoryId = null == found.getStatusCategory() ? defaultStatusCategoryId : found.getStatusCategory().getId();
                mapping = new StatusMapping(statusId, step.getName(), found.getId(), this.getValidStatusName(found.getName()), statusCategoryId);
            } else if (statusInfoMap.containsKey(statusId)) {
                StatusInfo info = (StatusInfo)statusInfoMap.get(statusId);
                mapping = new StatusMapping(info.getOriginalId(), info.getName(), "-1", this.getValidStatusName(info.getName()), info.getStatusCategoryId());
            } else {
                mapping = new StatusMapping(statusId, step.getName(), "-1", this.getValidStatusName(step.getName()), defaultStatusCategoryId);
            }
            holders.put(statusId, mapping);
        }
        return holders;
    }

    private WorkflowDescriptor getWorkflowDescriptor(String xml) {
        WorkflowDescriptor descriptor;
        try {
            descriptor = WorkflowUtil.convertXMLtoWorkflowDescriptor((String)xml);
        }
        catch (FactoryException e) {
            throw new RuntimeException(e);
        }
        return descriptor;
    }

    @Override
    public List<Status> getJiraStatuses() {
        return ImmutableList.copyOf((Collection)this.constantsManager.getStatusObjects());
    }

    @Override
    public void removeStatus(String id) throws Exception {
        ServiceResult serviceResult = this.statusService.removeStatus(this.authenticationContext.getUser(), this.constantsManager.getStatusObject(id));
        if (!serviceResult.isValid()) {
            throw new Exception();
        }
    }

    @Override
    public Status createStatus(String newName, String newStatusDefaultIcon) throws Exception {
        return this.createStatus(newName, newStatusDefaultIcon, StatusCategoryImpl.getDefault().getId());
    }

    @Override
    public Status createStatus(StatusMapping mapping, String newStatusDefaultIcon) throws Exception {
        return this.createStatus(mapping.getNewName(), newStatusDefaultIcon, mapping.getStatusCategoryId());
    }

    private Status createStatus(String newName, String newStatusDefaultIcon, Long newStatusCategoryId) throws Exception {
        String validName = this.getValidStatusName(newName);
        StatusCategory category = this.getCategory(newStatusCategoryId);
        ServiceOutcome serviceOutcome = this.statusService.createStatus(this.authenticationContext.getUser(), validName, "", newStatusDefaultIcon, category);
        if (!serviceOutcome.isValid()) {
            throw new Exception();
        }
        return (Status)serviceOutcome.getReturnedValue();
    }

    @Override
    public String getValidStatusName(String name) {
        return this.validNameGenerator.getValidName(name, 60, new Function<String, Boolean>(){

            public Boolean apply(String statusName) {
                for (Status status : WorkflowStatusHelperImpl.this.constantsManager.getStatusObjects()) {
                    if (!status.getName().equalsIgnoreCase(statusName)) continue;
                    return true;
                }
                return false;
            }
        });
    }

    @Override
    public String getNameForStatusId(String id) {
        String name = this.i18n.getText("wfshare.exception.status.not.found");
        Status status = this.constantsManager.getStatusObject(id);
        if (null != status) {
            name = status.getName();
        }
        return name;
    }

    @Override
    public SimpleStatus getSimpleStatusFromMapping(StatusMapping statusMapping) {
        return new SimpleStatusImpl("", statusMapping.getNewName(), "", this.getCategory(statusMapping.getStatusCategoryId()), "");
    }

    private StatusCategory getCategory(Long categoryId) {
        return null == categoryId ? StatusCategoryImpl.getDefault() : StatusCategoryImpl.findById((Long)categoryId);
    }

    private class StatusNamePredicate
    implements Predicate<Status> {
        private final String name;

        private StatusNamePredicate(String name) {
            this.name = name;
        }

        public boolean apply(Status status) {
            return this.name.equalsIgnoreCase(status.getName());
        }
    }
}

