/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.plugins.workflow.sharing.importer.component;

import com.atlassian.jira.plugins.workflow.sharing.importer.component.PacBundleDownloader;
import com.atlassian.jira.plugins.workflow.sharing.importer.component.WorkflowBundle;
import com.atlassian.jira.plugins.workflow.sharing.servlet.ValidationException;
import com.atlassian.jira.plugins.workflow.sharing.util.HttpResult;
import com.atlassian.jira.plugins.workflow.sharing.util.HttpUtils;
import com.atlassian.plugin.spring.scanner.annotation.export.ExportAsService;
import com.atlassian.sal.api.message.I18nResolver;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.net.URI;
import java.net.URISyntaxException;
import org.apache.commons.io.IOUtils;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpRequestBase;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@ExportAsService
@Component
public class PacBundleDownloaderImpl
implements PacBundleDownloader {
    private final I18nResolver i18n;
    private final WorkflowBundle.Factory bundleFactory;

    @Autowired
    public PacBundleDownloaderImpl(I18nResolver i18n, WorkflowBundle.Factory bundleFactory) {
        this.i18n = i18n;
        this.bundleFactory = bundleFactory;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public WorkflowBundle downloadBundle(String downloadUri) throws IOException, URISyntaxException, ValidationException {
        WorkflowBundle workflowBundle;
        URI uri = new URI(downloadUri);
        HttpGet method = new HttpGet(uri);
        HttpResult result = null;
        InputStream is = null;
        try {
            result = HttpUtils.execute((HttpRequestBase)method);
            HttpResponse response = result.getResponse();
            long responseContentLength = response.getEntity().getContentLength();
            if (responseContentLength > 0x500000L) {
                throw new ValidationException(this.i18n.getText("wfshare.exception.workflow.too.big"));
            }
            int status = response.getStatusLine().getStatusCode();
            if (200 != status) {
                throw new ValidationException(this.i18n.getText("wfshare.exception.download.error", new Serializable[]{Integer.valueOf(status)}));
            }
            is = response.getEntity().getContent();
            workflowBundle = this.bundleFactory.bundle(is, WorkflowBundle.BundleSource.MPAC);
        }
        catch (Throwable throwable) {
            IOUtils.closeQuietly(is);
            if (result != null) {
                result.close();
            }
            throw throwable;
        }
        IOUtils.closeQuietly((InputStream)is);
        if (result != null) {
            result.close();
        }
        return workflowBundle;
    }
}

