/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.plugins.workflow.sharing.importer.component;

import com.atlassian.jira.plugins.workflow.sharing.importer.component.BundleParser;
import com.atlassian.jira.plugins.workflow.sharing.importer.component.WorkflowBundle;
import com.atlassian.jira.plugins.workflow.sharing.servlet.ValidationException;
import com.atlassian.sal.api.message.I18nResolver;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class DefaultWorkflowBundleFactory
implements WorkflowBundle.Factory {
    private final BundleParser bundleParser;

    @Autowired
    public DefaultWorkflowBundleFactory(I18nResolver helper) {
        this(helper, 0x500000L, 0x100000L);
    }

    public DefaultWorkflowBundleFactory(I18nResolver resolver, long maxStream, long maxEntry) {
        this.bundleParser = new BundleParser(new I18nResolverErrorMessageProvider(resolver), maxStream, maxEntry);
    }

    @Override
    public WorkflowBundle bundle(InputStream stream, WorkflowBundle.BundleSource source) throws IOException, ValidationException {
        BundleParser.Builder builder = this.bundleParser.parse(stream, true);
        return builder.setSource(source).build();
    }

    private class I18nResolverErrorMessageProvider
    implements BundleParser.ErrorMessageProvider {
        private final I18nResolver i18n;

        I18nResolverErrorMessageProvider(I18nResolver i18n) {
            this.i18n = i18n;
        }

        @Override
        public String notZip() {
            return this.i18n.getText("wfshare.exception.file.must.be.a.zip.file");
        }

        @Override
        public String bundleEntryTooBig(long size, long maxSize) {
            return this.i18n.getText("wfshare.exception.workflow.too.big");
        }

        @Override
        public String invalidJson(String fileName) {
            return this.i18n.getText("wfshare.exception.invalid.file", new Serializable[]{fileName});
        }

        @Override
        public String unknownFile(String fileName) {
            return this.i18n.getText("wfshare.exception.unknown.file", new Serializable[]{fileName});
        }

        @Override
        public String noWorkflowXml() {
            return this.i18n.getText("wfshare.exception.workflow.xml.not.found.in.zip");
        }
    }
}

