/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.plugins.workflow.sharing.importer;

import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.jira.util.I18nHelper;
import com.google.common.base.Function;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class ValidNameGenerator {
    private final JiraAuthenticationContext jiraAuthenticationContext;

    @Autowired
    public ValidNameGenerator(JiraAuthenticationContext jiraAuthenticationContext) {
        this.jiraAuthenticationContext = jiraAuthenticationContext;
    }

    public String getValidName(String originalName, int maxLength, Function<String, Boolean> nameAlreadyExists) {
        String name = StringUtils.abbreviate((String)originalName, (int)maxLength);
        if (!((Boolean)nameAlreadyExists.apply((Object)name)).booleanValue()) {
            return name;
        }
        I18nHelper i18nHelper = this.jiraAuthenticationContext.getI18nHelper();
        int j = 2;
        while (((Boolean)nameAlreadyExists.apply((Object)name)).booleanValue()) {
            String prefix = i18nHelper.getText("wfshare.import.copy.prefix", String.valueOf(j++));
            int prefixLength = prefix.length();
            int abbreviateTo = maxLength - prefixLength;
            String abbreviatedName = StringUtils.abbreviate((String)originalName, (int)abbreviateTo);
            name = i18nHelper.getText("wfshare.import.copy", abbreviatedName, prefix);
        }
        return name;
    }
}

