/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.plugins.workflow.sharing.file;

import com.atlassian.jira.config.util.JiraHome;
import com.atlassian.jira.plugins.workflow.sharing.file.CanNotCreateFileException;
import com.atlassian.jira.plugins.workflow.sharing.file.FileManager;
import com.atlassian.jira.plugins.workflow.sharing.file.FileNameMapper;
import com.atlassian.plugin.spring.scanner.annotation.export.ExportAsService;
import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.filefilter.AgeFileFilter;
import org.apache.commons.lang.RandomStringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@ExportAsService
@Component
public class FileManagerImpl
implements FileManager,
InitializingBean,
DisposableBean {
    private final Logger LOG = LoggerFactory.getLogger(FileManagerImpl.class);
    public static final String BASE_EXPORT_FOLDER = "workflowexports";
    private final JiraHome jiraHome;
    private final FileNameMapper exportFileNameMapper = new FileNameMapper();

    @Autowired
    public FileManagerImpl(JiraHome jiraHome) {
        this.jiraHome = jiraHome;
    }

    @Override
    public File createExportedWorkflowFile() throws IOException, CanNotCreateFileException {
        File file = null;
        File baseFolder = this.getExportDirectory();
        file = this.createFile(file, baseFolder);
        this.checkIsWritable(file);
        return file;
    }

    private File createFile(File file, File baseFolder) throws CanNotCreateFileException {
        int maxRetries = 100;
        for (int i = 0; i < maxRetries; ++i) {
            String fileName = this.generateFileName();
            file = new File(baseFolder, fileName);
            if (file.exists()) continue;
            return file;
        }
        throw new CanNotCreateFileException();
    }

    @Override
    public File getExportedWorkflowFile(String filename) throws IOException {
        File baseFolder = this.getExportDirectory();
        File exportFile = new File(baseFolder, filename);
        if (exportFile.getParentFile().getAbsolutePath().equals(baseFolder.getAbsolutePath())) {
            return exportFile;
        }
        throw new IllegalArgumentException(String.format("Requested file is not correct: %s", filename));
    }

    private File getExportDirectory() throws IOException {
        File exportDir = new File(this.jiraHome.getExportDirectory(), BASE_EXPORT_FOLDER);
        FileUtils.forceMkdir((File)exportDir);
        return exportDir;
    }

    private void checkIsWritable(File file) throws CanNotCreateFileException {
        if (!file.exists()) {
            try {
                if (!file.createNewFile()) {
                    throw new CanNotCreateFileException();
                }
            }
            catch (IOException e) {
                throw new CanNotCreateFileException();
            }
        }
        if (!file.canWrite()) {
            throw new CanNotCreateFileException();
        }
        FileUtils.deleteQuietly((File)file);
    }

    private String generateFileName() {
        return RandomStringUtils.randomAlphabetic((int)5);
    }

    @Override
    public void clearOlderThan(long ageInMs) throws IOException {
        this.LOG.debug("Deleting all workflow files older than " + ageInMs + " ms");
        this.clearOlderThan(this.getExportDirectory(), ageInMs, this.exportFileNameMapper);
    }

    @Override
    public void addExportedFileNameMapping(String actualName, String nameToDisplay) {
        this.exportFileNameMapper.addFile(actualName, nameToDisplay);
    }

    @Override
    public String getExportFileNameToDisplay(String actualFilename) {
        return this.exportFileNameMapper.getNameToDisplay(actualFilename);
    }

    @Override
    public void clearExportFileNameMapping(String actualName) {
        this.exportFileNameMapper.clearFile(actualName);
    }

    @Override
    public void delete(File file) {
        FileUtils.deleteQuietly((File)file);
    }

    private void clearOlderThan(File directory, long ageInMs, FileNameMapper fileNameMapper) throws IOException {
        File[] files;
        for (File file : files = directory.listFiles((FileFilter)new AgeFileFilter(System.currentTimeMillis() - ageInMs, true))) {
            if (!FileUtils.deleteQuietly((File)file)) {
                this.LOG.warn("File " + file + " could not be deleted");
                continue;
            }
            if (fileNameMapper == null) continue;
            fileNameMapper.clearFile(file.getName());
        }
    }

    public void afterPropertiesSet() {
        this.deleteAllWorkflowFiles();
    }

    public void destroy() {
        this.deleteAllWorkflowFiles();
    }

    @Override
    public void deleteAllWorkflowFiles() {
        this.LOG.debug("Deleting all workflow files");
        this.exportFileNameMapper.clearAllFiles();
        try {
            FileUtils.cleanDirectory((File)this.getExportDirectory());
        }
        catch (Exception e) {
            this.LOG.debug("Could not clean the workflow export directory", (Throwable)e);
        }
    }
}

