/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.plugins.workflow.sharing;

import com.atlassian.jira.plugins.workflow.sharing.ModuleDescriptorLocator;
import com.atlassian.jira.plugins.workflow.sharing.WorkflowPluginHelper;
import com.atlassian.plugin.ModuleDescriptor;
import com.atlassian.plugin.Plugin;
import com.atlassian.plugin.spring.scanner.annotation.export.ExportAsService;
import java.util.Collection;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@ExportAsService
@Component
public class WorkflowPluginHelperImpl
implements WorkflowPluginHelper {
    private final ModuleDescriptorLocator moduleDescriptorLocator;

    @Autowired
    public WorkflowPluginHelperImpl(ModuleDescriptorLocator moduleDescriptorLocator) {
        this.moduleDescriptorLocator = moduleDescriptorLocator;
    }

    @Override
    public boolean isFromPlugin(String className) {
        if (StringUtils.isEmpty((String)className)) {
            return false;
        }
        Collection<ModuleDescriptor> moduleDescriptors = this.moduleDescriptorLocator.getEnabledModuleDescriptorsByModuleClassname(className);
        for (ModuleDescriptor moduleDescriptor : moduleDescriptors) {
            Plugin plugin = moduleDescriptor.getPlugin();
            if (plugin.getKey().startsWith("com.atlassian.jira.plugin.system")) continue;
            return true;
        }
        return false;
    }
}

