/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.plugins.workflow.sharing;

import com.atlassian.jira.plugins.workflow.sharing.WhitelistChecker;
import com.atlassian.plugin.spring.scanner.annotation.export.ExportAsService;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.HashSet;
import java.util.Set;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.stereotype.Component;

@ExportAsService
@Component
public class WhitelistCheckerImpl
implements WhitelistChecker,
InitializingBean {
    private Set<String> allowedClassNames;

    public void afterPropertiesSet() throws IOException {
        this.readFromResource("/whitelist.txt");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void readFromResource(String resourceName) throws IOException {
        this.allowedClassNames = new HashSet<String>();
        try (BufferedReader reader = null;){
            String line;
            reader = new BufferedReader(new InputStreamReader(this.getClass().getResourceAsStream(resourceName)));
            while ((line = reader.readLine()) != null) {
                this.allowedClassNames.add(line);
            }
        }
    }

    @Override
    public boolean isAllowed(String className) {
        return this.allowedClassNames.contains(className);
    }
}

