/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.plugins.workflow.sharing;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.opensymphony.workflow.loader.ActionDescriptor;
import java.util.Collection;
import java.util.Set;

public class RemovedItems {
    private final Collection<ActionRemovedItems> allActionRemovedItems = Lists.newArrayList();

    void add(ActionRemovedItems actionRemovedItems) {
        this.allActionRemovedItems.add(actionRemovedItems);
    }

    public boolean isEmpty() {
        for (ActionRemovedItems actionRemovedItems : this.allActionRemovedItems) {
            if (actionRemovedItems.isEmpty()) continue;
            return false;
        }
        return true;
    }

    public Collection<ActionRemovedItems> getActionRemovedItems() {
        return this.allActionRemovedItems;
    }

    public static class ActionRemovedItems {
        private final ActionDescriptor action;
        private final Set<String> functions = Sets.newHashSet();
        private final Set<String> validators = Sets.newHashSet();
        private final Set<String> conditions = Sets.newHashSet();
        private final Set<String> customFields = Sets.newHashSet();
        private boolean replacedEventId;

        public ActionRemovedItems(ActionDescriptor action) {
            this.action = action;
        }

        public ActionDescriptor getAction() {
            return this.action;
        }

        void addFunctionClass(String function) {
            this.functions.add(function);
        }

        void addValidatorClass(String validator) {
            this.validators.add(validator);
        }

        void addConditionClass(String condition) {
            this.conditions.add(condition);
        }

        void addCustomFieldClass(String customField) {
            this.customFields.add(customField);
        }

        public Set<String> getFunctions() {
            return this.functions;
        }

        public Set<String> getValidators() {
            return this.validators;
        }

        public Set<String> getConditions() {
            return this.conditions;
        }

        public Set<String> getCustomFields() {
            return this.customFields;
        }

        public boolean isReplacedEventId() {
            return this.replacedEventId;
        }

        public void markReplacedEventId() {
            this.replacedEventId = true;
        }

        public boolean isEmpty() {
            return this.functions.isEmpty() && this.validators.isEmpty() && this.conditions.isEmpty() && this.customFields.isEmpty() && !this.replacedEventId;
        }
    }
}

