/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.plugins.workflow.sharing;

import com.atlassian.jira.plugin.workflow.AbstractWorkflowModuleDescriptor;
import com.atlassian.jira.plugins.workflow.sharing.ModuleDescriptorLocator;
import com.atlassian.plugin.ModuleDescriptor;
import com.atlassian.plugin.ModuleDescriptorFactory;
import com.atlassian.plugin.PluginAccessor;
import com.atlassian.plugin.predicate.EnabledModulePredicate;
import com.atlassian.plugin.predicate.ModuleDescriptorOfTypePredicate;
import com.atlassian.plugin.predicate.ModuleDescriptorPredicate;
import com.atlassian.plugin.spring.scanner.annotation.export.ExportAsService;
import com.atlassian.sal.api.message.I18nResolver;
import java.util.Collection;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@ExportAsService
@Component
public class ModuleDescriptorLocatorImpl
implements ModuleDescriptorLocator {
    private final PluginAccessor pluginAccessor;
    private final I18nResolver i18n;
    private ModuleDescriptorFactory moduleDescriptorFactory;

    @Autowired
    public ModuleDescriptorLocatorImpl(PluginAccessor pluginAccessor, I18nResolver i18n, ModuleDescriptorFactory moduleDescriptorFactory) {
        this.pluginAccessor = pluginAccessor;
        this.i18n = i18n;
        this.moduleDescriptorFactory = moduleDescriptorFactory;
    }

    @Override
    public Collection<ModuleDescriptor> getEnabledModuleDescriptorsByModuleClassname(String moduleClassname) {
        return this.getEnabledModuleDescriptors(new ModuleOfClassnamePredicate(moduleClassname));
    }

    @Override
    public Collection<ModuleDescriptor> getEnabledModuleDescriptorsByModuleType(String moduleType) {
        return this.getEnabledModuleDescriptors((ModuleDescriptorPredicate<ModuleDescriptor>)new ModuleDescriptorOfTypePredicate(this.moduleDescriptorFactory, moduleType));
    }

    private Collection<ModuleDescriptor> getEnabledModuleDescriptors(final ModuleDescriptorPredicate<ModuleDescriptor> predicate) {
        final EnabledModulePredicate enabled = new EnabledModulePredicate(this.pluginAccessor);
        return this.pluginAccessor.getModuleDescriptors(new ModuleDescriptorPredicate(){

            public boolean matches(ModuleDescriptor moduleDescriptor) {
                return predicate.matches(moduleDescriptor) && enabled.matches(moduleDescriptor);
            }
        });
    }

    public class ModuleOfClassnamePredicate
    implements ModuleDescriptorPredicate {
        private final String moduleClassname;

        public ModuleOfClassnamePredicate(String moduleClassname) {
            if (moduleClassname == null) {
                throw new IllegalArgumentException(ModuleDescriptorLocatorImpl.this.i18n.getText("wfshare.exception.module.classname.should.not.be.null"));
            }
            this.moduleClassname = moduleClassname;
        }

        public boolean matches(ModuleDescriptor moduleDescriptor) {
            if (moduleDescriptor != null) {
                if (AbstractWorkflowModuleDescriptor.class.isAssignableFrom(moduleDescriptor.getClass()) && !moduleDescriptor.getPluginKey().equals("com.atlassian.jira.plugin.system.workflow")) {
                    AbstractWorkflowModuleDescriptor wfModuleDescriptor = (AbstractWorkflowModuleDescriptor)moduleDescriptor;
                    Class workflowClassInDescriptor = wfModuleDescriptor.getImplementationClass();
                    return workflowClassInDescriptor != null && workflowClassInDescriptor.getName().equals(this.moduleClassname);
                }
                if (!AbstractWorkflowModuleDescriptor.class.isAssignableFrom(moduleDescriptor.getClass())) {
                    Class moduleClassInDescriptor = moduleDescriptor.getModuleClass();
                    return null != moduleClassInDescriptor && moduleClassInDescriptor.getName().equals(this.moduleClassname);
                }
            }
            return false;
        }
    }
}

