/*
 * Decompiled with CFR 0.152.
 */
package electric.xml.tools;

import electric.util.io.Streams;
import electric.util.string.Strings;
import electric.xml.Document;
import electric.xml.ParseException;
import electric.xml.sax.SAXParser;
import java.io.File;
import java.io.IOException;
import org.xml.sax.SAXException;

public class Parse {
    private static String filename;
    private static boolean keepWhitespace;
    private static boolean silent;
    private static int count;
    private static boolean useSAX;

    public static void main(String[] args) {
        if (args.length == 0) {
            Parse.printUsage();
            return;
        }
        try {
            Parse.processArgs(args);
            Parse.parse();
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
            Parse.printUsage();
            System.exit(-1);
        }
    }

    private static void printUsage() {
        System.out.println("usage: parse filename [-h] [-n count] [-s] [-w] [-x]");
        System.out.println();
        System.out.println("where:");
        System.out.println("  filename = filename of XML document to parse");
        System.out.println("  -h       = print help and exit");
        System.out.println("  -n count = number of times to parse, 1 by default");
        System.out.println("  -s       = silent, don't print document");
        System.out.println("  -w       = keep whitespace");
        System.out.println("  -x       = use SAX parser instead of DOM");
        System.out.println();
        System.out.println("examples:");
        System.out.println();
        System.out.println("parse myfile.xml");
        System.out.println("  parse myfile.xml once, display statistics");
        System.out.println();
        System.out.println("parse myfile.xml -n 10 -w");
        System.out.println("  parse myfile.xml 10 times, keep whitespace, display statistics");
    }

    private static void processArgs(String[] args) throws Throwable {
        int i = 0;
        while (i < args.length) {
            String arg = args[i];
            if (!arg.startsWith("-")) {
                filename = arg;
            } else {
                if (arg.length() == 1) {
                    throw new IllegalArgumentException("a plain - is not a valid argument");
                }
                switch (arg.charAt(1)) {
                    case 'h': {
                        Parse.printUsage();
                        System.exit(-1);
                    }
                    case 'n': {
                        String n = Strings.getString("n", args, ++i);
                        count = Integer.parseInt(n);
                        break;
                    }
                    case 's': {
                        silent = true;
                        break;
                    }
                    case 'w': {
                        keepWhitespace = true;
                        break;
                    }
                    case 'x': {
                        useSAX = true;
                        break;
                    }
                    default: {
                        throw new IllegalArgumentException("illegal argument " + arg.charAt(1));
                    }
                }
            }
            ++i;
        }
    }

    private static void parse() throws IOException, ParseException, SAXException {
        File file = new File(filename);
        byte[] bytes = Streams.readFully(file);
        Document document = null;
        long start = System.currentTimeMillis();
        int i = 0;
        while (i < count) {
            if (useSAX) {
                new SAXParser().parse(bytes);
            } else {
                document = keepWhitespace ? new Document(bytes, 1) : new Document(bytes);
            }
            ++i;
        }
        long stop = System.currentTimeMillis();
        long milliseconds = stop - start;
        System.out.println("total parsing time = " + milliseconds + "ms");
        if (count > 1) {
            System.out.println("individial parsing time = " + (float)milliseconds / (float)count + "ms");
        }
        if (!silent && !useSAX) {
            System.out.println();
            System.out.println(document);
        }
    }

    static {
        keepWhitespace = false;
        silent = false;
        count = 1;
        useSAX = false;
    }
}

