/*
 * Decompiled with CFR 0.152.
 */
package electric.xml.substitute;

import electric.xml.Attribute;
import electric.xml.Element;
import electric.xml.NamespaceException;
import electric.xml.Node;
import electric.xml.NodeReader;
import electric.xml.substitute.TagData;
import java.io.IOException;
import java.io.Reader;

public final class SubstituteReader
extends NodeReader {
    private TagData tagData;

    public SubstituteReader(Reader reader, int flags, TagData tagData) {
        super(reader, flags);
        this.tagData = tagData;
    }

    public void read(Node node) throws IOException, NamespaceException {
        if (node instanceof Element) {
            this.readElement((Element)node);
        } else if (node instanceof Attribute) {
            this.readAttribute((Attribute)node);
        } else {
            super.read(node);
        }
    }

    public void readElement(Element element) throws IOException, NamespaceException {
        this.read();
        String name = this.readToken();
        String prefix = null;
        if (this.peek() == 58) {
            prefix = name;
            if (Character.isDigit(prefix.charAt(0))) {
                prefix = this.tagData.getName(prefix);
            }
            this.read();
            name = this.readToken();
        }
        if (Character.isDigit(name.charAt(0))) {
            name = this.tagData.getName(name);
        }
        this.skipWhitespace();
        int peek = this.peek();
        if (peek != 62 && peek != 47) {
            element.readAttributes(this);
        }
        String namespace = null;
        if (prefix == null) {
            namespace = element.getDefaultNamespace();
        } else {
            namespace = element.getNamespace(prefix);
            if (namespace == null) {
                throw new NamespaceException("could not find namespace with prefix " + prefix);
            }
        }
        element.setName(prefix, name, namespace);
        int ch = this.read();
        if (ch == 47) {
            this.readChar(62);
        } else {
            if (ch != 62) {
                throw new IOException("expected > or /");
            }
            element.readChildren(this);
            this.readChar(60);
            this.readChar(47);
            if (prefix != null) {
                this.readToken();
                this.readChar(58);
            }
            this.readToken();
            this.readChar(62);
        }
    }

    public void readAttribute(Attribute attribute) throws IOException, NamespaceException {
        String name = this.readToken();
        String prefix = null;
        if (this.peek() == 58) {
            prefix = name;
            if (Character.isDigit(prefix.charAt(0))) {
                prefix = this.tagData.getName(prefix);
            }
            this.read();
            name = this.readToken();
        }
        if (Character.isDigit(name.charAt(0))) {
            name = this.tagData.getName(name);
        }
        this.readChar(61);
        this.skipWhitespace();
        String value = null;
        int ch = this.read();
        if (ch == 34) {
            value = this.readToPattern("\"", 66);
        } else if (ch == 39) {
            value = this.readToPattern("'", 66);
        } else {
            throw new IOException("missing quote at start of attribute");
        }
        attribute.initialize(prefix, name, value);
    }
}

