/*
 * Decompiled with CFR 0.152.
 */
package electric.xml.io.simple;

import electric.util.classloader.ClassLoaders;
import electric.util.string.Strings;
import electric.xml.Element;
import electric.xml.io.ITypeFactory;
import electric.xml.io.Mappings;
import electric.xml.io.Namespaces;
import electric.xml.io.Type;
import electric.xml.io.schema.ISchemaConstants;
import electric.xml.io.schema.SchemaException;
import electric.xml.io.simple.EnumerationUtil;
import electric.xml.io.simple.Restriction;

public final class SimpleTypeFactory
implements ITypeFactory,
ISchemaConstants {
    public Type newType(Namespaces namespaces, Class javaClass) throws SchemaException {
        if (EnumerationUtil.isEnumeration(javaClass)) {
            String packageName = Strings.getJavaPackage(javaClass.getName());
            String namespace = Mappings.getNamespace(packageName);
            String name = Strings.getLocalJavaName(javaClass.getName());
            return new Restriction(namespaces, namespace, name, javaClass);
        }
        return null;
    }

    public Type newType(Namespaces namespaces, String namespace, String name, Element schema) throws SchemaException {
        if (!schema.getName().equals("simpleType")) {
            return null;
        }
        if (name == null) {
            name = schema.getAttributeValue("name");
        }
        if (name == null) {
            return null;
        }
        Element restriction = schema.getElement("restriction");
        if (restriction != null) {
            Restriction type = new Restriction(namespaces, namespace, name, schema);
            String javaName = Mappings.getJavaName(namespace, name);
            if (javaName == null && ((Type)type).getJavaName() == null) {
                return null;
            }
            return type;
        }
        throw new SchemaException("<simpleType> " + namespace + ":" + name + " currently only supports <restriction>");
    }

    public Type newType(Namespaces namespaces, String namespace, String name) throws SchemaException {
        String javaName = Mappings.getJavaName(namespace, name);
        if (javaName == null) {
            return null;
        }
        try {
            Class javaClass = ClassLoaders.loadClass(javaName);
            if (EnumerationUtil.isEnumeration(javaClass)) {
                return this.newType(namespaces, javaClass);
            }
        }
        catch (ClassNotFoundException exception) {}
        return null;
    }
}

