/*
 * Decompiled with CFR 0.152.
 */
package electric.xml.io.simple;

import electric.util.Value;
import electric.util.string.Base64;
import electric.xml.io.IReader;
import electric.xml.io.IWriter;
import electric.xml.io.schema.SchemaProperties;
import electric.xml.io.simple.SimpleType;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;

public final class ByteArrayType
extends SimpleType {
    static final Class BYTE_ARRAY_CLASS = new byte[0].getClass();
    static final byte[] NO_BYTES = new byte[0];

    public ByteArrayType() {
        this(SchemaProperties.getDefaultSchema());
    }

    public ByteArrayType(String namespace) {
        super(namespace, "base64Binary", BYTE_ARRAY_CLASS);
        this.setJavaName("byte[]");
    }

    public Class getJavaClass() {
        return BYTE_ARRAY_CLASS;
    }

    public boolean isStandard() {
        return true;
    }

    public void writeObject(IWriter writer, Object object) throws IOException {
        byte[] bytes = (byte[])object;
        if (bytes.length > 0) {
            writer.writeText(Base64.toBase64(bytes));
        }
    }

    public void readObject(IReader reader, Value value) throws IOException {
        String text = reader.readString().trim();
        ByteArrayOutputStream output = new ByteArrayOutputStream(text.length() * 3 / 4);
        Base64.fromBase64(new ByteArrayInputStream(text.getBytes()), output);
        byte[] bytes = output.toByteArray();
        value.setObject(bytes.length == 0 ? NO_BYTES : bytes);
    }
}

