/*
 * Decompiled with CFR 0.152.
 */
package electric.xml.io.model;

import electric.util.Value;
import electric.util.array.ArrayUtil;
import electric.util.java.JavaSource;
import electric.util.reflect.Accessibility;
import electric.util.reflect.BeanField;
import electric.xml.Element;
import electric.xml.Elements;
import electric.xml.io.IReader;
import electric.xml.io.IWriter;
import electric.xml.io.Type;
import electric.xml.io.accessors.FieldAccessor;
import electric.xml.io.accessors.PropertyAccessor;
import electric.xml.io.model.IModel;
import electric.xml.io.schema.Schema;
import electric.xml.io.schema.SchemaAttribute;
import electric.xml.io.schema.SchemaElement;
import electric.xml.io.schema.SchemaException;
import java.io.IOException;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.Vector;

public class All
extends Type
implements IModel {
    private static boolean directFieldAccess = true;
    private static boolean propertySuppression = true;
    protected Type parentType;
    protected SchemaElement[] elements = new SchemaElement[0];

    public All() {
    }

    public All(Type parentType) {
        this.setParentType(parentType);
    }

    public All(Type parentType, Element schema) throws SchemaException {
        this.setParentType(parentType);
        this.readSchema(schema);
    }

    public All(Schema schemaObject, Element schemaElement) throws SchemaException {
        this.setSchema(schemaObject);
        this.readSchema(schemaElement);
    }

    public void addElement(SchemaElement element) {
        this.elements = (SchemaElement[])ArrayUtil.addElement(this.elements, element);
    }

    public void setElements(Class javaClass) throws SchemaException {
        if (Accessibility.canSetAccessible() && All.getDirectFieldAccess()) {
            this.setChildTypePrivate(javaClass);
        } else {
            this.setChildTypePublic(javaClass);
        }
    }

    public SchemaElement[] getElements() {
        return this.elements;
    }

    public SchemaElement getSchemaElement(String name) throws SchemaException {
        int i = 0;
        while (i < this.elements.length) {
            if (this.elements[i].getName().equals(name)) {
                return this.elements[i];
            }
            ++i;
        }
        return null;
    }

    public SchemaAttribute getSchemaAttribute(String name) throws SchemaException {
        return null;
    }

    private void setChildTypePrivate(Class javaClass) throws SchemaException {
        AccessibleObject[] fields = javaClass.getDeclaredFields();
        Field.setAccessible(fields, true);
        int i = 0;
        while (i < fields.length) {
            this.addFieldAccessor((Field)fields[i]);
            ++i;
        }
    }

    private void setChildTypePublic(Class javaClass) throws SchemaException {
        Field[] fields = javaClass.getDeclaredFields();
        Vector<String> fieldNames = new Vector<String>();
        boolean noPublicFields = true;
        int i = 0;
        while (i < fields.length) {
            if (Modifier.isPublic(fields[i].getModifiers())) {
                noPublicFields = false;
                break;
            }
            ++i;
        }
        if (noPublicFields || !All.getPropertySuppression()) {
            BeanField[] beanFields = BeanField.getBeanFields(javaClass);
            int i2 = 0;
            while (i2 < beanFields.length) {
                BeanField field = beanFields[i2];
                fieldNames.addElement(field.name);
                Type elementType = this.getNamespaces().getTypeWithJavaClass(field.type);
                SchemaElement schemaElement = new SchemaElement(this.parentType, field.name, elementType);
                schemaElement.setAccessor(new PropertyAccessor(schemaElement, schemaElement.getName(), field));
                if (elementType.useSchemaElement()) {
                    schemaElement.setNillable(elementType.getSchemaElement().getNillable());
                }
                this.addElement(schemaElement);
                ++i2;
            }
        }
        int i3 = 0;
        while (i3 < fields.length) {
            Field field = fields[i3];
            int modifiers = field.getModifiers();
            if (!fieldNames.contains(field.getName()) && Modifier.isPublic(modifiers)) {
                this.addFieldAccessor(field);
            }
            ++i3;
        }
    }

    public void addDependencies(Vector dependencies) throws SchemaException {
        int i = 0;
        while (i < this.elements.length) {
            this.elements[i].addDependencies(dependencies);
            ++i;
        }
    }

    protected void setParentType(Type parentType) {
        this.parentType = parentType;
        if (parentType.getSchema() != null) {
            this.setSchema(parentType.getSchema());
        }
    }

    public void writeJava(JavaSource source) throws SchemaException {
        int i = 0;
        while (i < this.elements.length) {
            this.elements[i].writeJava(source);
            ++i;
        }
    }

    public Class getJavaClass() throws SchemaException {
        return this.parentType.getJavaClass();
    }

    public String getJavaName() throws SchemaException {
        return this.parentType.getJavaName();
    }

    public void readSchema(Element schema) throws SchemaException {
        Elements elements = schema.getElements();
        while (elements.hasMoreElements()) {
            Element child = elements.next();
            if (this.parentType != null) {
                if (child.getName().equals("element")) {
                    this.addElement(new SchemaElement(this.parentType, child));
                    continue;
                }
                if (child.getName().equals("annotation")) continue;
                throw new SchemaException("<all> in type " + this.parentType.getQName() + " is only allowed to contain <element> or <annotation> children");
            }
            if (child.getName().equals("element")) {
                this.addElement(new SchemaElement(this.schema, child));
                continue;
            }
            if (child.getName().equals("annotation")) continue;
            throw new SchemaException("<all> is only allowed to contain <element> or <annotation> children");
        }
    }

    public void writeSchema(Element element, boolean annotated) throws SchemaException {
        if (this.elements.length > 0) {
            String xsdPrefix = Type.getXSDPrefix(element);
            Element all = element.addElement(xsdPrefix, "all");
            int i = 0;
            while (i < this.elements.length) {
                this.elements[i].writeSchema(all, annotated);
                ++i;
            }
        }
    }

    public void setSchema(Schema schema) {
        super.setSchema(schema);
        int i = 0;
        while (i < this.elements.length) {
            this.elements[i].setSchema(schema);
            ++i;
        }
    }

    private void addFieldAccessor(Field field) throws SchemaException {
        int modifiers = field.getModifiers();
        if (Modifier.isStatic(modifiers) || Modifier.isTransient(modifiers) || Modifier.isFinal(modifiers)) {
            return;
        }
        Type elementType = this.getNamespaces().getTypeWithJavaClass(field.getType());
        SchemaElement schemaElement = new SchemaElement(this, field.getName(), elementType);
        schemaElement.setAccessor(new FieldAccessor(schemaElement, field.getName()));
        if (elementType.useSchemaElement()) {
            schemaElement.setNillable(elementType.getSchemaElement().getNillable());
        }
        this.addElement(schemaElement);
    }

    public static void setDirectFieldAccess(boolean flag) {
        directFieldAccess = flag;
    }

    public static boolean getDirectFieldAccess() {
        return directFieldAccess;
    }

    public static void setPropertySuppression(boolean flag) {
        propertySuppression = flag;
    }

    public static boolean getPropertySuppression() {
        return propertySuppression;
    }

    public void forceResolution() {
        int i = 0;
        while (i < this.elements.length) {
            try {
                this.elements[i].getType();
            }
            catch (SchemaException exception) {
                // empty catch block
            }
            ++i;
        }
    }

    public void writeObject(IWriter writer, Object object) throws IOException {
        int i = 0;
        while (i < this.elements.length) {
            writer.writeObject(this.elements[i], object);
            ++i;
        }
    }

    public void readObject(IReader reader, Value value) throws IOException {
        int i = 0;
        while (i < this.elements.length) {
            this.elements[i].readObject(reader, value);
            ++i;
        }
    }
}

