/*
 * Decompiled with CFR 0.152.
 */
package electric.xml.io.collections.net;

import electric.util.Value;
import electric.xml.Element;
import electric.xml.io.IReader;
import electric.xml.io.IWriter;
import electric.xml.io.Type;
import electric.xml.io.collections.net.CollectionType;
import electric.xml.io.schema.SchemaException;
import java.io.IOException;
import java.util.Enumeration;
import java.util.Hashtable;

public class HashtableType
extends CollectionType {
    public void writeSchema(Element schema) throws SchemaException {
        Type type = this.getType(CollectionType.OBJECT_ARRAY_CLASS);
        String xsdPrefix = Type.getXSDPrefix(schema);
        Element complexType = schema.addElement(xsdPrefix, "complexType");
        complexType.setAttribute("name", "Hashtable");
        Element sequence = complexType.addElement(xsdPrefix, "sequence");
        Element keys = sequence.addElement(xsdPrefix, "element");
        keys.setAttribute("name", "keys");
        keys.setAttribute("type", Type.getName(type.getNamespace(), type.getName(), keys));
        Element values = sequence.addElement(xsdPrefix, "element");
        values.setAttribute("name", "values");
        values.setAttribute("type", Type.getName(type.getNamespace(), type.getName(), values));
    }

    public void writeObject(IWriter writer, Object object) throws IOException {
        Hashtable table = (Hashtable)object;
        Object[] keys = new Object[table.size()];
        Object[] values = new Object[table.size()];
        Enumeration keyEnum = table.keys();
        Enumeration valueEnum = table.elements();
        int i = 0;
        while (i < keys.length) {
            keys[i] = keyEnum.nextElement();
            values[i] = valueEnum.nextElement();
            ++i;
        }
        this.writeArray(writer, "keys", keys);
        this.writeArray(writer, "values", values);
    }

    public void readObject(IReader reader, Value value) throws IOException {
        Hashtable<Object, Object> hashtable = (Hashtable<Object, Object>)value.getObject();
        if (hashtable == null) {
            hashtable = new Hashtable<Object, Object>();
            value.setObject(hashtable);
        }
        Object[] keys = this.readArray(reader, "keys");
        Object[] values = this.readArray(reader, "values");
        int i = 0;
        while (i < keys.length) {
            hashtable.put(keys[i], values[i]);
            ++i;
        }
    }
}

