/*
 * Decompiled with CFR 0.152.
 */
package electric.xml.io.collections.net;

import electric.util.Value;
import electric.xml.Element;
import electric.xml.io.IReader;
import electric.xml.io.IWriter;
import electric.xml.io.Type;
import electric.xml.io.collections.net.CollectionType;
import electric.xml.io.schema.SchemaException;
import java.io.IOException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

public class HashMapType
extends CollectionType {
    public void writeSchema(Element schema) throws SchemaException {
        Type type = this.getType(CollectionType.OBJECT_ARRAY_CLASS);
        String xsdPrefix = Type.getXSDPrefix(schema);
        Element complexType = schema.addElement(xsdPrefix, "complexType");
        complexType.setAttribute("name", "HashMap");
        Element sequence = complexType.addElement(xsdPrefix, "sequence");
        Element keys = sequence.addElement(xsdPrefix, "element");
        keys.setAttribute("name", "keys");
        keys.setAttribute("type", Type.getName(type.getNamespace(), type.getName(), keys));
        Element values = sequence.addElement(xsdPrefix, "element");
        values.setAttribute("name", "values");
        values.setAttribute("type", Type.getName(type.getNamespace(), type.getName(), values));
    }

    public void writeObject(IWriter writer, Object object) throws IOException {
        HashMap map = (HashMap)object;
        Object[] keys = new Object[map.size()];
        Object[] values = new Object[map.size()];
        Iterator entries = map.entrySet().iterator();
        int i = 0;
        while (i < keys.length) {
            Map.Entry entry = entries.next();
            keys[i] = entry.getKey();
            values[i] = entry.getValue();
            ++i;
        }
        this.writeArray(writer, "keys", keys);
        this.writeArray(writer, "values", values);
    }

    public void readObject(IReader reader, Value value) throws IOException {
        HashMap<Object, Object> map = (HashMap<Object, Object>)value.getObject();
        if (map == null) {
            map = new HashMap<Object, Object>();
            value.setObject(map);
        }
        Object[] keys = this.readArray(reader, "keys");
        Object[] values = this.readArray(reader, "values");
        int i = 0;
        while (i < keys.length) {
            map.put(keys[i], values[i]);
            ++i;
        }
    }
}

