/*
 * Decompiled with CFR 0.152.
 */
package electric.xml.io.array;

import electric.util.Value;
import electric.util.array.ArrayUtil;
import electric.xml.Element;
import electric.xml.io.IReader;
import electric.xml.io.IWriter;
import electric.xml.io.Type;
import electric.xml.io.array.ArrayType;
import electric.xml.io.array.ArrayTypeFactory;
import electric.xml.io.schema.Schema;
import electric.xml.io.schema.SchemaException;
import electric.xml.io.schema.SchemaLocations;
import java.io.IOException;
import java.lang.reflect.Array;

public class MultidimEncodedArrayType
extends ArrayType {
    protected int[] dimensions;

    public MultidimEncodedArrayType(Schema schema, String name, String componentQName, int[] dimensions) {
        super(schema, name);
        this.componentQName = componentQName;
        this.dimensions = dimensions;
    }

    public int[] getDimensions() {
        return this.dimensions;
    }

    public String toString() {
        try {
            return "MultidimEncodedArrayType( name=" + this.getNamespace() + ":" + this.name + ", arrayType=" + this.getArrayTypeQName(new Element()) + " )";
        }
        catch (SchemaException exception) {
            return "MultidimEncodedArrayType( " + exception + " )";
        }
    }

    public void writeSchema(Element schema) throws SchemaException {
        String soapPrefix = schema.getPrefix("http://schemas.xmlsoap.org/soap/encoding/", "soapenc");
        String wsdlPrefix = schema.getPrefix("http://schemas.xmlsoap.org/wsdl/", "wsdl");
        String xsdPrefix = Type.getXSDPrefix(schema);
        SchemaLocations.appendImport(schema, "http://schemas.xmlsoap.org/soap/encoding/", null);
        if (!this.getComponentType().getNamespace().equals(this.getNamespace()) && !this.getComponentType().useAnonymous()) {
            SchemaLocations.appendImport(schema, this.getComponentType().getNamespace(), null);
        }
        Element complexType = schema.addElement(xsdPrefix, "complexType");
        complexType.setAttribute("name", this.getName());
        Element complexContent = complexType.addElement(xsdPrefix, "complexContent");
        Element restriction = complexContent.addElement(xsdPrefix, "restriction");
        restriction.setAttribute("base", soapPrefix + ":Array");
        Element attribute = restriction.addElement(xsdPrefix, "attribute");
        attribute.setAttribute("ref", soapPrefix + ":arrayType");
        attribute.setAttribute(wsdlPrefix, "arrayType", this.getArrayTypeQName(schema));
    }

    public String getArrayTypeQName(Element element) throws SchemaException {
        Type runtimeComponentType = this.getComponentType();
        StringBuffer buffer = new StringBuffer();
        buffer.append("[");
        int i = 0;
        while (i < this.dimensions.length) {
            if (i > 0) {
                buffer.append(",");
            }
            if (this.dimensions[i] > 0) {
                buffer.append(this.dimensions[i]);
            }
            ++i;
        }
        if (runtimeComponentType instanceof ArrayType) {
            buffer.insert(0, ((ArrayType)runtimeComponentType).getArrayTypeQName(element));
        } else {
            buffer.insert(0, runtimeComponentType.getName(element));
        }
        buffer.append("]");
        return buffer.toString();
    }

    public String getArrayTypeQName(Object object, Element element, int[] dimensions, boolean writeSize) throws IOException {
        Type runtimeComponentType = this.getComponentType();
        StringBuffer buffer = new StringBuffer();
        buffer.append("[");
        Object array = object;
        int i = 0;
        while (i < dimensions.length) {
            if (i > 0) {
                buffer.append(",");
            }
            if (array != null) {
                int length = Array.getLength(array);
                if (dimensions[i] != -1 && dimensions[i] < length) {
                    throw new IOException("array too large for the dimensions specified in the wsdl.");
                }
                if (length == 0) {
                    dimensions[i] = 0;
                    array = null;
                } else {
                    Object member = Array.get(array, 0);
                    int j = 0;
                    while (j < length && member == null) {
                        member = Array.get(array, j);
                        ++j;
                    }
                    dimensions[i] = length;
                    array = member;
                }
            } else if (dimensions[i] == -1) {
                dimensions[i] = 0;
            }
            if (dimensions[i] != 0 && writeSize) {
                buffer.append(dimensions[i]);
            }
            ++i;
        }
        if (runtimeComponentType instanceof ArrayType) {
            buffer.insert(0, ((ArrayType)runtimeComponentType).getArrayTypeQName(array, element, (int[])((ArrayType)runtimeComponentType).getDimensions().clone(), false));
        } else {
            buffer.insert(0, runtimeComponentType.getName(element));
        }
        buffer.append("]");
        return buffer.toString();
    }

    public void writeObject(IWriter writer, Object object) throws SchemaException, IOException {
        int[] new_dimensions = (int[])this.dimensions.clone();
        String soapPrefix = writer.getElement().getPrefix("http://schemas.xmlsoap.org/soap/encoding/", "soapenc");
        String arrayTypeQName = this.getArrayTypeQName(object, writer.getElement(), new_dimensions, true);
        writer.writeAttribute(soapPrefix, "arrayType", arrayTypeQName);
        this.writeMultiDimArray(object, writer, new_dimensions);
    }

    protected void writeMultiDimArray(Object object, IWriter writer, int[] dimensions) throws IOException {
        int numElements = 1;
        int i = 0;
        while (i < dimensions.length) {
            numElements *= dimensions[i];
            ++i;
        }
        int i2 = 0;
        while (i2 < numElements) {
            block5: {
                int j = i2;
                Object array = object;
                int[] position = new int[dimensions.length];
                int z = position.length;
                while (z > 0) {
                    position[z - 1] = j % dimensions[z - 1];
                    j /= dimensions[z - 1];
                    --z;
                }
                int z2 = 0;
                while (z2 < dimensions.length - 1) {
                    Object member = Array.get(array, position[z2]);
                    if (member == null) {
                        writer.writeObject(this.item, (Object)null, this.getComponentType());
                        break block5;
                    }
                    array = member;
                    ++z2;
                }
                Object item = Array.get(array, position[dimensions.length - 1]);
                writer.writeObject(this.item, item, this.getComponentType());
            }
            ++i2;
        }
    }

    protected synchronized Class findJavaClass() {
        Class<?> javaClass;
        block3: {
            javaClass = null;
            try {
                Class componentClass = this.getComponentType().getJavaClass();
                if (ArrayUtil.indexOf(-1, this.dimensions) != -1) {
                    javaClass = Array.newInstance(componentClass, new int[this.dimensions.length]).getClass();
                    break block3;
                }
                javaClass = Array.newInstance(componentClass, this.dimensions).getClass();
            }
            catch (Exception exception) {}
        }
        return javaClass;
    }

    public synchronized String getJavaName() throws SchemaException {
        if (this.javaName != null) {
            return this.javaName;
        }
        StringBuffer buffer = new StringBuffer();
        buffer.append(this.getComponentType().getJavaName());
        int i = 0;
        while (i < this.dimensions.length) {
            buffer.append("[]");
            ++i;
        }
        this.javaName = buffer.toString();
        return this.javaName;
    }

    public void readObject(IReader reader, Value value) throws SchemaException, IOException {
        IReader[] children = reader.getReaders();
        Object array = null;
        String arrayType = reader.getElement().getAttributeValue("arrayType");
        int[] wireDimensions = null;
        wireDimensions = arrayType == null || arrayType.indexOf("[") == -1 ? this.dimensions : ArrayTypeFactory.getDimensions(arrayType);
        if (ArrayUtil.indexOf(-1, wireDimensions) != -1) {
            int i = 0;
            while (i < wireDimensions.length) {
                if (wireDimensions[i] == -1) {
                    wireDimensions[i] = 0;
                }
                ++i;
            }
        }
        array = Array.newInstance(this.getComponentType().getJavaClass(), wireDimensions);
        int i = 0;
        while (i < children.length) {
            int j = i;
            Object object = array;
            int[] position = new int[this.dimensions.length];
            int z = position.length - 1;
            while (z < 0) {
                position[z] = j % wireDimensions[z];
                j /= wireDimensions[z];
                --z;
            }
            int z2 = 0;
            while (z2 < this.dimensions.length - 1) {
                object = Array.get(object, position[z2]);
                ++z2;
            }
            Object item = children[i].readValue(this.getComponentType()).getObject();
            Array.set(object, position[position.length - 1], item);
            ++i;
        }
        value.setObject(array);
    }
}

