/*
 * Decompiled with CFR 0.152.
 */
package electric.xml.io.array;

import electric.util.Context;
import electric.util.array.ArrayUtil;
import electric.util.classloader.ClassLoaders;
import electric.util.log.ILoggingConstants;
import electric.util.log.Log;
import electric.xml.Element;
import electric.xml.Elements;
import electric.xml.IXPath;
import electric.xml.io.ITypeFactory;
import electric.xml.io.Namespaces;
import electric.xml.io.Type;
import electric.xml.io.array.ArrayType;
import electric.xml.io.array.LiteralArrayType;
import electric.xml.io.array.MultidimEncodedArrayType;
import electric.xml.io.array.SOAP12ArrayType;
import electric.xml.io.array.SOAP12MultidimEncodedArrayType;
import electric.xml.io.schema.EncodingMismatchException;
import electric.xml.io.schema.ISchemaConstants;
import electric.xml.io.schema.SchemaException;
import electric.xml.xpath.TMEXPath;
import java.lang.reflect.Array;
import java.lang.reflect.Constructor;

public final class ArrayTypeFactory
implements ITypeFactory,
ISchemaConstants {
    private static final IXPath restrictionXPath;
    private static final IXPath elementXPath;
    private static Constructor defaultArrayTypeConstructor;
    private String encodingStyle = (String)Context.thread().getProperty("encodingStyle");
    private Constructor arrayTypeConstructor = this.encodingStyle == null ? defaultArrayTypeConstructor : (this.encodingStyle.equals("") ? (class$electric$xml$io$array$LiteralArrayType == null ? (class$electric$xml$io$array$LiteralArrayType = ArrayTypeFactory.class$("electric.xml.io.array.LiteralArrayType")) : class$electric$xml$io$array$LiteralArrayType).getConstructor(class$electric$xml$io$Namespaces == null ? (class$electric$xml$io$Namespaces = ArrayTypeFactory.class$("electric.xml.io.Namespaces")) : class$electric$xml$io$Namespaces, class$java$lang$Class == null ? (class$java$lang$Class = ArrayTypeFactory.class$("java.lang.Class")) : class$java$lang$Class) : (this.encodingStyle.equals("http://schemas.xmlsoap.org/soap/encoding/") ? (class$electric$xml$io$array$ArrayType == null ? (class$electric$xml$io$array$ArrayType = ArrayTypeFactory.class$("electric.xml.io.array.ArrayType")) : class$electric$xml$io$array$ArrayType).getConstructor(class$electric$xml$io$Namespaces == null ? (class$electric$xml$io$Namespaces = ArrayTypeFactory.class$("electric.xml.io.Namespaces")) : class$electric$xml$io$Namespaces, class$java$lang$Class == null ? (class$java$lang$Class = ArrayTypeFactory.class$("java.lang.Class")) : class$java$lang$Class) : defaultArrayTypeConstructor));
    static /* synthetic */ Class class$electric$xml$io$Namespaces;
    static /* synthetic */ Class class$java$lang$Class;
    static /* synthetic */ Class class$electric$xml$io$array$ArrayType;
    static /* synthetic */ Class class$electric$xml$io$array$LiteralArrayType;

    public static String getDefaultArrayType() {
        return defaultArrayTypeConstructor.getDeclaringClass().getName();
    }

    public static void setDefaultArrayType(String defaultArrayType) throws Exception {
        Class defaultArrayTypeClass = ClassLoaders.loadClass(defaultArrayType);
        defaultArrayTypeConstructor = defaultArrayTypeClass.getConstructor(class$electric$xml$io$Namespaces == null ? (class$electric$xml$io$Namespaces = ArrayTypeFactory.class$("electric.xml.io.Namespaces")) : class$electric$xml$io$Namespaces, class$java$lang$Class == null ? (class$java$lang$Class = ArrayTypeFactory.class$("java.lang.Class")) : class$java$lang$Class);
    }

    public Type newType(Namespaces namespaces, Class javaClass) throws SchemaException {
        if (!javaClass.isArray()) {
            return null;
        }
        try {
            Constructor ctor = this.arrayTypeConstructor;
            String arrayTypeName = (String)Context.thread().getProperty("arrayTypeName");
            if (arrayTypeName != null) {
                Class defaultArrayTypeClass = ClassLoaders.loadClass(arrayTypeName);
                ctor = defaultArrayTypeClass.getConstructor(class$electric$xml$io$Namespaces == null ? (class$electric$xml$io$Namespaces = ArrayTypeFactory.class$("electric.xml.io.Namespaces")) : class$electric$xml$io$Namespaces, class$java$lang$Class == null ? (class$java$lang$Class = ArrayTypeFactory.class$("java.lang.Class")) : class$java$lang$Class);
            }
            return (Type)ctor.newInstance(namespaces, javaClass);
        }
        catch (Exception exception) {
            String message = "Could not construct ArrayType out of class " + javaClass;
            if (Log.isLogging(ILoggingConstants.EXCEPTION_EVENT)) {
                Log.log(ILoggingConstants.EXCEPTION_EVENT, message, exception);
            }
            throw new SchemaException(message);
        }
    }

    public Type newType(Namespaces namespaces, String namespace, String name, Element schema) throws SchemaException {
        Element arrayType;
        Element element = schema;
        String newName = element.getAttributeValue("name");
        if (newName != null) {
            name = newName;
        }
        if (!this.isArray(element)) {
            return null;
        }
        Element restriction = element.getElement(restrictionXPath);
        if (namespaces.getEnforceEncodingStyle()) {
            if (restriction == null) {
                if (this.encodingStyle == null || this.encodingStyle.equals("")) {
                    return new LiteralArrayType(namespaces.findSchema(namespace), name, element.getElement(elementXPath));
                }
                throw new EncodingMismatchException("expecting soap encoded array, got literal");
            }
            if (this.encodingStyle == null || this.encodingStyle.equals("")) {
                throw new EncodingMismatchException("expecting literal array, got encoded");
            }
        } else if (restriction == null) {
            return new LiteralArrayType(namespaces.findSchema(namespace), name, element.getElement(elementXPath));
        }
        if ((arrayType = this.getArrayTypeElement(restriction)) == null) {
            return new LiteralArrayType(namespaces.findSchema(namespace), name, restriction.getElement(elementXPath));
        }
        String componentQName = arrayType.getAttributeValue("arrayType");
        int[] dim = ArrayTypeFactory.getDimensions(componentQName);
        componentQName = arrayType.getQName(ArrayTypeFactory.getComponentQName(componentQName));
        return this.getEncoded(namespaces, namespace, name, componentQName, dim);
    }

    private Element getArrayTypeElement(Element restriction) {
        Elements elements = restriction.getElements("attribute");
        Element arrayType = null;
        while (elements.hasMoreElements()) {
            String ref;
            Element attrElement = elements.next();
            String qname = attrElement.getQName(ref = attrElement.getAttributeValue("ref"));
            if (!qname.equals("http://schemas.xmlsoap.org/soap/encoding/:arrayType")) continue;
            arrayType = attrElement;
            break;
        }
        return arrayType;
    }

    private Type getEncoded(Namespaces namespaces, String namespace, String name, String componentQName, int[] dim) {
        if (dim.length == 1) {
            if ("http://www.w3.org/2003/05/soap-encoding".equals(this.encodingStyle)) {
                return new SOAP12ArrayType(namespaces, namespace, name, componentQName, dim[0]);
            }
            return new ArrayType(namespaces, namespace, name, componentQName, dim[0]);
        }
        if ("http://www.w3.org/2003/05/soap-encoding".equals(this.encodingStyle)) {
            return new SOAP12MultidimEncodedArrayType(namespaces.findSchema(namespace), name, componentQName, dim);
        }
        return new MultidimEncodedArrayType(namespaces.findSchema(namespace), name, componentQName, dim);
    }

    public Type newType(Namespaces namespaces, String namespace, String name) throws SchemaException {
        if (name.startsWith("ArrayOf")) {
            Type componentType = namespaces.getTypeWithQName(ArrayType.getComponentNamespace(namespace), name.substring("ArrayOf".length()));
            String componentQName = componentType.getQName();
            if (componentType == null) {
                return null;
            }
            if (this.encodingStyle == null || this.encodingStyle.equals("http://www.w3.org/2003/05/soap-encoding") || this.encodingStyle.equals("http://schemas.xmlsoap.org/soap/encoding/")) {
                return this.getEncoded(namespaces, namespace, name, componentQName, new int[]{-1});
            }
            return new LiteralArrayType(namespaces, Array.newInstance(componentType.getJavaClass(), 0).getClass());
        }
        if (name.indexOf(91) != -1) {
            int[] dim = ArrayTypeFactory.getDimensions(name);
            String componentName = ArrayTypeFactory.getComponentQName(name);
            String componentNamespace = ArrayType.getComponentNamespace(namespace);
            Type componentType = namespaces.getTypeWithQName(componentNamespace, componentName);
            if (componentType == null) {
                return null;
            }
            String componentQName = componentType.getQName();
            if (this.encodingStyle == null || this.encodingStyle.equals("http://www.w3.org/2003/05/soap-encoding") || this.encodingStyle.equals("http://schemas.xmlsoap.org/soap/encoding/")) {
                return this.getEncoded(namespaces, namespace, name, componentQName, dim);
            }
            return new LiteralArrayType(namespaces, Array.newInstance(componentType.getJavaClass(), 0).getClass());
        }
        return null;
    }

    private boolean hasArrayBase(Element element) {
        String base = element.getAttributeValue("base");
        if (base == null) {
            return false;
        }
        return (base = element.getQName(base)).equals("http://schemas.xmlsoap.org/soap/encoding/:Array") || base.equals("http://schemas.xmlsoap.org/wsdl/soap/:Array");
    }

    private boolean isArray(Element element) {
        if (element.hasElement("attribute")) {
            return false;
        }
        Element childElement = element.getElement(restrictionXPath);
        if (childElement != null) {
            return this.hasArrayBase(childElement);
        }
        childElement = element.getElement("sequence");
        Elements elements = element.getElements(elementXPath);
        if (childElement != null && childElement.getElements().size() == 1 && elements != null) {
            return this.isArray(elements);
        }
        String name = element.getAttributeValue("name");
        return name != null && (name.startsWith("ArrayOf") || name.indexOf(91) != -1);
    }

    private boolean isArray(Elements elements) {
        if (elements.size() != 1) {
            return false;
        }
        Element element = elements.next();
        String maxOccurs = element.getAttributeValue("maxOccurs");
        if (maxOccurs == null) {
            return false;
        }
        if (maxOccurs.equals("unbounded") || maxOccurs.equals("*")) {
            return true;
        }
        return Integer.parseInt(maxOccurs) > 1;
    }

    /*
     * Unable to fully structure code
     */
    public static int[] getDimensions(String arrayQName) throws IllegalArgumentException, NumberFormatException {
        openBrace = arrayQName.lastIndexOf(91);
        closeBrace = arrayQName.lastIndexOf(93);
        position = openBrace;
        maxOccurs = new int[]{};
        if (openBrace != -1 && closeBrace >= openBrace) ** GOTO lbl13
        throw new IllegalArgumentException("malformed arrayQName " + arrayQName);
lbl-1000:
        // 1 sources

        {
            newPosition = arrayQName.indexOf(44, position + 1);
            if (newPosition == -1) {
                newPosition = closeBrace;
            }
            nextDimension = (dimString = arrayQName.substring(position + 1, newPosition).trim()).equals("") != false ? -1 : Integer.parseInt(dimString);
            maxOccurs = ArrayUtil.addElement(maxOccurs, nextDimension);
            position = newPosition;
lbl13:
            // 2 sources

            ** while (position != closeBrace)
        }
lbl14:
        // 1 sources

        return maxOccurs;
    }

    public static String getComponentQName(String arrayQName) {
        int openBrace = arrayQName.lastIndexOf(91);
        return openBrace == -1 ? null : arrayQName.substring(0, openBrace);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        block2: {
            restrictionXPath = new TMEXPath("complexContent/restriction");
            elementXPath = new TMEXPath("sequence/element");
            try {
                defaultArrayTypeConstructor = (class$electric$xml$io$array$ArrayType == null ? (class$electric$xml$io$array$ArrayType = ArrayTypeFactory.class$("electric.xml.io.array.ArrayType")) : class$electric$xml$io$array$ArrayType).getConstructor(class$electric$xml$io$Namespaces == null ? (class$electric$xml$io$Namespaces = ArrayTypeFactory.class$("electric.xml.io.Namespaces")) : class$electric$xml$io$Namespaces, class$java$lang$Class == null ? (class$java$lang$Class = ArrayTypeFactory.class$("java.lang.Class")) : class$java$lang$Class);
            }
            catch (Throwable throwable) {
                if (!Log.isLogging(ILoggingConstants.EXCEPTION_EVENT | ILoggingConstants.WARNING_EVENT)) break block2;
                Log.log(ILoggingConstants.EXCEPTION_EVENT | ILoggingConstants.WARNING_EVENT, "Could not get a reference to ArrayType, arrays may not work.", throwable);
            }
        }
    }
}

