/*
 * Decompiled with CFR 0.152.
 */
package electric.xml.config;

import electric.util.classloader.ClassLoaders;
import electric.util.log.ILoggingConstants;
import electric.util.log.Log;
import electric.xml.Element;
import electric.xml.Elements;
import electric.xml.IEXMLLoggingConstants;
import electric.xml.IXPathFactory;
import electric.xml.XPath;
import electric.xml.config.IEXMLConfigConstants;

public final class XPathConfig
implements IEXMLLoggingConstants,
IEXMLConfigConstants {
    public void config(Element config) throws Throwable {
        Element xpath = config.getElement("xpath");
        if (xpath == null) {
            return;
        }
        Elements factoryElements = xpath.getElements("factory");
        while (factoryElements.hasMoreElements()) {
            Element factoryElement = factoryElements.next();
            String xpathFactory = factoryElement.getString();
            if (xpathFactory == null || xpathFactory.length() == 0) continue;
            try {
                Class factoryClass = ClassLoaders.loadClass(xpathFactory);
                if (XPath.getFactory() == null) {
                    XPath.setFactory((IXPathFactory)factoryClass.newInstance());
                    continue;
                }
                XPath.addFactory((IXPathFactory)factoryClass.newInstance());
            }
            catch (Throwable exception) {
                if (!Log.isLogging(ILoggingConstants.EXCEPTION_EVENT)) continue;
                Log.log(ILoggingConstants.EXCEPTION_EVENT, "could not load XPath Factory: ", exception);
            }
        }
        if (xpath.hasElement("cacheByDefault")) {
            XPath.setCacheByDefault(xpath.getBoolean("cacheByDefault"));
        }
    }
}

