/*
 * Decompiled with CFR 0.152.
 */
package electric.xml;

import electric.util.named.INamed;
import electric.util.named.IQNamed;
import electric.xml.Node;
import java.io.Serializable;
import org.w3c.dom.NamedNodeMap;

public final class NodeList
implements Serializable,
org.w3c.dom.NodeList,
NamedNodeMap {
    public Node first;
    public Node last;

    public boolean isEmpty() {
        return this.first == null;
    }

    private Node getNode(String name) {
        Node node = this.first;
        while (node != null) {
            if (((INamed)((Object)node)).getName().equals(name)) {
                return node;
            }
            node = node.next;
        }
        return null;
    }

    private Node getNode(String namespaceURI, String localName) {
        Node node = this.first;
        while (node != null) {
            if (localName.equals(((IQNamed)((Object)node)).getName()) && (namespaceURI == null || namespaceURI.equals(((IQNamed)((Object)node)).getNamespace()))) {
                return node;
            }
            node = node.next;
        }
        return null;
    }

    public void append(Node node) {
        node.remove();
        node.list = this;
        node.prev = this.last;
        node.next = null;
        if (this.first == null) {
            this.first = node;
        } else {
            this.last.next = node;
        }
        this.last = node;
    }

    public void insert(Node node) {
        node.remove();
        node.list = this;
        node.next = this.first;
        node.prev = null;
        if (this.last == null) {
            this.last = node;
        } else {
            this.first.prev = node;
        }
        this.first = node;
    }

    public void remove(Node node) {
        if (node.prev == null) {
            this.first = node.next;
        } else {
            node.prev.next = node.next;
        }
        if (node.next == null) {
            this.last = node.prev;
        } else {
            node.next.prev = node.prev;
        }
        node.prev = null;
        node.next = null;
        node.list = null;
    }

    public void replace(Node oldNode, Node newNode) {
        newNode.remove();
        newNode.list = this;
        if (oldNode.prev == null) {
            this.first = newNode;
        } else {
            oldNode.prev.next = newNode;
        }
        if (oldNode.next == null) {
            this.last = newNode;
        } else {
            oldNode.next.prev = newNode;
        }
        newNode.prev = oldNode.prev;
        newNode.next = oldNode.next;
        oldNode.list = null;
    }

    public void addSiblingNode(Node node, Node newNode) {
        newNode.remove();
        newNode.list = this;
        newNode.next = node.next;
        newNode.prev = node;
        if (node.next == null) {
            this.last = newNode;
        } else {
            node.next.prev = newNode;
        }
        node.next = newNode;
    }

    public void insertSiblingNode(Node node, Node newNode) {
        newNode.remove();
        newNode.list = this;
        newNode.prev = node.prev;
        newNode.next = node;
        if (node.prev == null) {
            this.first = newNode;
        } else {
            node.prev.next = newNode;
        }
        node.prev = newNode;
    }

    public int size() {
        int count = 0;
        Node node = this.first;
        while (node != null) {
            ++count;
            node = node.next;
        }
        return count;
    }

    public void clear() {
        this.first = null;
        this.last = null;
    }

    public int getLength() {
        return this.size();
    }

    public org.w3c.dom.Node item(int index) {
        if (index < 0) {
            return null;
        }
        Node node = this.first;
        int i = 0;
        while (i < index) {
            if (node == null) {
                return null;
            }
            node = node.next;
            ++i;
        }
        return node.getNode();
    }

    public org.w3c.dom.Node getNamedItem(String name) {
        return this.getNode(name);
    }

    public org.w3c.dom.Node setNamedItem(org.w3c.dom.Node node) {
        Node oldNode = this.getNode(node.getNodeName());
        if (oldNode == null) {
            this.append((Node)node);
            return null;
        }
        this.replace(oldNode, (Node)node);
        return oldNode;
    }

    public org.w3c.dom.Node removeNamedItem(String name) {
        Node node = this.getNode(name);
        if (node != null) {
            node.remove();
        }
        return node;
    }

    public org.w3c.dom.Node getNamedItemNS(String namespaceURI, String localName) {
        return this.getNode(namespaceURI, localName);
    }

    public org.w3c.dom.Node setNamedItemNS(org.w3c.dom.Node node) {
        Node oldNode = this.getNode(node.getNamespaceURI(), node.getLocalName());
        if (oldNode == null) {
            this.append((Node)node);
            return null;
        }
        this.replace(oldNode, (Node)node);
        return oldNode;
    }

    public org.w3c.dom.Node removeNamedItemNS(String namespaceURI, String localName) {
        Node node = this.getNode(namespaceURI, localName);
        if (node != null) {
            node.remove();
        }
        return node;
    }
}

