/*
 * Decompiled with CFR 0.152.
 */
package electric.xml;

import electric.util.io.FastBufferedReader;
import electric.util.io.FastStringReader;
import electric.util.io.Streams;
import electric.util.string.Strings;
import electric.xml.Attribute;
import electric.xml.CData;
import electric.xml.Comment;
import electric.xml.DocType;
import electric.xml.Element;
import electric.xml.Fragment;
import electric.xml.Implementation;
import electric.xml.Instruction;
import electric.xml.NamespaceException;
import electric.xml.Node;
import electric.xml.NodeList;
import electric.xml.NodeReader;
import electric.xml.NodeWriter;
import electric.xml.Parent;
import electric.xml.ParseException;
import electric.xml.Text;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import java.io.UnsupportedEncodingException;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import org.w3c.dom.Attr;
import org.w3c.dom.CDATASection;
import org.w3c.dom.DOMException;
import org.w3c.dom.DOMImplementation;
import org.w3c.dom.DocumentFragment;
import org.w3c.dom.DocumentType;
import org.w3c.dom.EntityReference;
import org.w3c.dom.ProcessingInstruction;

public class Document
extends Parent
implements org.w3c.dom.Document {
    public static final int KEEP_WHITESPACE = 1;
    public static final int MAJOR_VERSION = 6;
    public static final int MINOR_VERSION = 1;
    private static final Implementation implementation = new Implementation();
    private Hashtable context;
    private boolean stripped = true;
    private String version = "1.0";
    private String encoding = "UTF-8";
    private boolean standalone = false;
    private boolean setStandalone = false;
    private boolean writeXMLDecl = true;

    public Document() {
    }

    public Document(Hashtable context) {
        this.context = context;
    }

    public Document(String string) throws ParseException {
        this(string, 0);
    }

    public Document(String string, int flags) throws ParseException {
        new NodeReader(new FastStringReader(string), flags).parse(this);
    }

    public Document(byte[] bytes) throws ParseException {
        this(bytes, null, 0);
    }

    public Document(byte[] bytes, int flags) throws ParseException {
        this(bytes, null, flags);
    }

    public Document(byte[] bytes, Hashtable context) throws ParseException {
        this(bytes, context, 0);
    }

    public Document(byte[] bytes, Hashtable context, int flags) throws ParseException {
        this.context = context;
        try {
            new NodeReader(new FastStringReader(Strings.toString(bytes)), flags).parse(this);
        }
        catch (UnsupportedEncodingException exception) {
            throw new ParseException(exception.toString());
        }
    }

    public Document(File file) throws ParseException {
        this(file, 0);
    }

    public Document(File file, int flags) throws ParseException {
        try {
            new NodeReader(new FastBufferedReader(Streams.getReader(file)), flags).parse(this);
        }
        catch (IOException exception) {
            throw new ParseException(exception.toString());
        }
    }

    public Document(InputStream stream) throws ParseException {
        this(stream, 0);
    }

    public Document(InputStream stream, int flags) throws ParseException {
        try {
            new NodeReader(new FastBufferedReader(Streams.getReader(stream)), flags).parse(this);
        }
        catch (IOException exception) {
            throw new ParseException(exception.toString());
        }
    }

    public Document(Reader reader) throws ParseException {
        new NodeReader(reader, 0).parse(this);
    }

    public Document(Reader reader, int flags) throws ParseException {
        new NodeReader(reader, flags).parse(this);
    }

    public Document(Reader reader, Hashtable context) throws ParseException {
        this.context = context;
        new NodeReader(reader, 0).parse(this);
    }

    public Document(Reader reader, Hashtable context, int flags) throws ParseException {
        this.context = context;
        new NodeReader(reader, flags).parse(this);
    }

    public Document(NodeReader nodeReader) throws ParseException {
        nodeReader.parse(this);
    }

    public Document(NodeReader nodeReader, Hashtable context) throws ParseException {
        this.context = context;
        nodeReader.parse(this);
    }

    public Document(Element root) {
        this.setRoot(root);
    }

    public Document(Document document) {
        super(document);
        this.context = document.context;
        this.version = document.version;
        this.encoding = document.encoding;
        this.standalone = document.standalone;
        this.setStandalone = document.setStandalone;
        this.writeXMLDecl = document.writeXMLDecl;
    }

    public boolean isStripped() {
        return this.stripped;
    }

    public Object clone() {
        return new Document(this);
    }

    public Document getDocument() {
        return this;
    }

    public Element getRoot() {
        Node node = this.children.first;
        while (node != null) {
            if (node instanceof Element) {
                return (Element)node;
            }
            node = node.next;
        }
        return null;
    }

    public Element newRoot() {
        return this.setRoot(new Element());
    }

    public Element setRoot(Element element) {
        Element root = this.getRoot();
        if (root != null) {
            root.replaceWith(element);
        } else {
            this.addChild(element);
        }
        return element;
    }

    public Element setRoot(String name) {
        Element root = this.newRoot();
        root.setName(name);
        return root;
    }

    public Element setRoot(String prefix, String name) {
        Element root = this.newRoot();
        root.setName(prefix, name);
        return root;
    }

    public Element setRoot(String prefix, String name, String namespace) {
        Element root = this.newRoot();
        root.setNamespace(prefix, namespace);
        root.setName(prefix, name);
        return root;
    }

    public DocType getDocType() {
        Node node = this.children.first;
        while (node != null) {
            if (node instanceof DocType) {
                return (DocType)node;
            }
            node = node.next;
        }
        return null;
    }

    public void read(NodeReader reader) throws IOException, NamespaceException {
        this.stripped = reader.isStrip();
        int elements = 0;
        this.writeXMLDecl = false;
        while (true) {
            StringBuffer whitespace;
            if ((whitespace = reader.readWhitespace()) != null && !reader.isStrip()) {
                new Text(this).setString(whitespace.toString());
            }
            reader.mark(2);
            int ch1 = reader.peekRead();
            int ch2 = reader.peekRead();
            reader.reset();
            if (ch1 == -1) break;
            if (ch2 == 33 && reader.peekString("<!--")) {
                reader.read(new Comment(this));
                continue;
            }
            if (ch2 == 33 && reader.peekString("<!DOCTYPE")) {
                reader.read(new DocType(this));
                continue;
            }
            if (ch2 == 63 && reader.peekString("<?xml ")) {
                this.writeXMLDecl = true;
                this.readXMLDecl(reader);
                continue;
            }
            if (ch2 == 63) {
                reader.read(new Instruction(this));
                continue;
            }
            Element element = new Element();
            this.addChild(element);
            reader.read(element);
            ++elements;
        }
        if (elements != 1) {
            throw new IOException("the document does not have exactly one root");
        }
        reader.skipWhitespace();
        if (reader.read() != -1) {
            throw new IOException("extra stuff at the end");
        }
    }

    public void write(NodeWriter writer) throws IOException {
        if (this.writeXMLDecl) {
            this.writeXMLDecl(writer);
        }
        Node node = this.children.first;
        while (node != null) {
            writer.write(node);
            if (node.next != null && this.stripped) {
                writer.writeEOL();
            }
            node = node.next;
        }
    }

    public String getVersion() {
        return this.version;
    }

    public void setVersion(String version) {
        this.version = version;
        this.writeXMLDecl = true;
    }

    public String getEncoding() {
        return this.encoding;
    }

    public void setEncoding(String encoding) {
        this.encoding = encoding;
        this.writeXMLDecl = true;
    }

    public boolean getStandalone() {
        return this.standalone;
    }

    public void setStandalone(boolean standalone) {
        this.standalone = standalone;
        this.setStandalone = true;
        this.writeXMLDecl = true;
    }

    public void setWriteXMLDecl(boolean flag) {
        this.writeXMLDecl = flag;
    }

    public boolean getWriteXMLDecl() {
        return this.writeXMLDecl;
    }

    private void readXMLDecl(NodeReader reader) throws IOException {
        reader.skip("<?xml ".length());
        int peek = 0;
        do {
            String key = reader.readToken();
            reader.readChar(61);
            reader.skipWhitespace();
            int ch = reader.read();
            String value = null;
            if (ch == 34) {
                value = reader.readToPattern("\"", 66);
            } else if (ch == 39) {
                value = reader.readToPattern("'", 66);
            } else {
                throw new IOException("missing quote at start of XMLDecl attribute");
            }
            if (key.equals("version")) {
                this.setVersion(value);
            } else if (key.equals("encoding")) {
                this.setEncoding(value);
            } else if (key.equals("standalone")) {
                this.setStandalone(value.equals("yes"));
            } else {
                throw new IOException(key + " is invalid attribute for XMLDecl");
            }
            reader.skipWhitespace();
        } while ((peek = reader.peek()) != 63);
        reader.readChar(63);
        reader.readChar(62);
    }

    private void writeXMLDecl(NodeWriter writer) throws IOException {
        writer.writeIndent();
        writer.write("<?xml ");
        writer.write("version");
        writer.write('=');
        writer.write(Attribute.getQuoteCharacter());
        writer.write(this.version);
        writer.write(Attribute.getQuoteCharacter());
        writer.write(' ');
        writer.write("encoding");
        writer.write('=');
        writer.write(Attribute.getQuoteCharacter());
        writer.write(this.encoding);
        writer.write(Attribute.getQuoteCharacter());
        if (this.setStandalone) {
            writer.write(" ");
            writer.write("standalone");
            writer.write('=');
            writer.write(Attribute.getQuoteCharacter());
            writer.write(this.standalone ? "yes" : "no");
            writer.write(Attribute.getQuoteCharacter());
        }
        writer.write("?>");
        writer.writeEOL();
    }

    public Hashtable getContext() {
        return this.context;
    }

    public void setContext(Hashtable context) {
        this.context = context;
    }

    public String getNamespace(String prefix) {
        if ("xml".equals(prefix)) {
            return "http://www.w3.org/XML/1998/namespace";
        }
        return this.context == null ? null : (String)this.context.get(prefix);
    }

    protected void addNamespacePrefixes(String namespace, Vector prefixes, Vector matches) {
        if (this.context == null) {
            return;
        }
        Enumeration enumeration = this.context.keys();
        while (enumeration.hasMoreElements()) {
            String prefix = (String)enumeration.nextElement();
            if (prefixes.contains(prefix) || !this.context.get(prefix).equals(namespace)) continue;
            matches.addElement(prefix);
        }
    }

    public String getNamespacePrefix(String namespace) {
        if ("http://www.w3.org/XML/1998/namespace".equals(namespace)) {
            return "xml";
        }
        if (this.context == null) {
            return null;
        }
        Enumeration enumeration = this.context.keys();
        while (enumeration.hasMoreElements()) {
            String prefix = (String)enumeration.nextElement();
            if (!this.context.get(prefix).equals(namespace)) continue;
            return prefix;
        }
        return null;
    }

    public int size() {
        int size = 0;
        if (this.writeXMLDecl) {
            size += "<?xml ".length() + "version".length() + 7 + this.version.length() + "encoding".length() + this.encoding.length();
            if (this.setStandalone) {
                size += 4 + "standalone".length() + (this.standalone ? 3 : 2);
            }
            size += "?>".length();
        }
        return size + super.size();
    }

    public org.w3c.dom.Node appendChild(org.w3c.dom.Node newChild) throws DOMException {
        Instruction instruction;
        if (newChild instanceof Instruction && (instruction = (Instruction)newChild).getTarget().startsWith("xml")) {
            try {
                StringReader stringReader = new StringReader("<?xml " + instruction.getContent() + "?>");
                NodeReader nodeReader = new NodeReader(stringReader);
                this.readXMLDecl(nodeReader);
                return instruction;
            }
            catch (IOException exception) {
                short code = 5;
                throw new DOMException(code, exception.toString());
            }
        }
        return super.appendChild(newChild);
    }

    public short getNodeType() {
        return 9;
    }

    public String getNodeName() {
        return "#document";
    }

    public Attr createAttribute(String name) {
        return new Attribute(name, null);
    }

    public Attr createAttributeNS(String namespaceURI, String qualifiedName) {
        String[] parts = Element.getParts(qualifiedName);
        Attribute attribute = new Attribute(parts[0], parts[1], null);
        attribute.namespace = namespaceURI;
        return attribute;
    }

    public CDATASection createCDATASection(String data) {
        return new CData(data);
    }

    public org.w3c.dom.Comment createComment(String data) {
        return new Comment(data);
    }

    public DocumentFragment createDocumentFragment() {
        return new Fragment();
    }

    public org.w3c.dom.Element createElement(String tagName) {
        return new Element(tagName);
    }

    public org.w3c.dom.Element createElementNS(String namespaceURI, String qualifiedName) {
        String[] parts = Element.getParts(qualifiedName);
        Element element = new Element(parts[1]);
        element.prefix = parts[0];
        element.namespace = namespaceURI;
        return element;
    }

    public EntityReference createEntityReference(String name) {
        return null;
    }

    public ProcessingInstruction createProcessingInstruction(String target, String data) {
        return new Instruction(target, data);
    }

    public org.w3c.dom.Text createTextNode(String data) {
        return new Text(data);
    }

    public DocumentType getDoctype() {
        return this.getDocType();
    }

    public org.w3c.dom.Element getDocumentElement() {
        return this.getRoot();
    }

    public org.w3c.dom.Element getElementById(String elementId) {
        return this.getElementWithId(elementId);
    }

    public org.w3c.dom.NodeList getElementsByTagName(String tagName) {
        NodeList nodes = new NodeList();
        Element root = this.getRoot();
        if (root != null) {
            root.addElementsByTagName(tagName, nodes);
        }
        return nodes;
    }

    public org.w3c.dom.NodeList getElementsByTagNameNS(String namespaceURI, String localName) {
        NodeList nodes = new NodeList();
        Element root = this.getRoot();
        if (root != null) {
            root.addElementsByTagNameNS(namespaceURI, localName, nodes);
        }
        return nodes;
    }

    public DOMImplementation getImplementation() {
        return implementation;
    }

    public org.w3c.dom.Node importNode(org.w3c.dom.Node importedNode, boolean deep) {
        return importedNode.cloneNode(deep);
    }
}

