/*
 * Decompiled with CFR 0.152.
 */
package electric.xdb.server;

import electric.util.array.ArrayUtil;
import electric.xdb.XDBException;
import electric.xdb.server.IXDBServer;
import electric.xdb.server.IXDBServersListener;

public class LocalXDBServers {
    private static IXDBServer[] servers = new IXDBServer[0];
    private static IXDBServersListener[] listeners = new IXDBServersListener[0];

    public static synchronized void addedServer(IXDBServer server) {
        servers = (IXDBServer[])ArrayUtil.addElement(servers, server);
        int i = 0;
        while (i < listeners.length) {
            listeners[i].addedLocalServer(server);
            ++i;
        }
    }

    public static synchronized void removedServer(IXDBServer server) {
        servers = (IXDBServer[])ArrayUtil.removeElementIdentity(servers, server);
        int i = 0;
        while (i < listeners.length) {
            listeners[i].removedLocalServer(server);
            ++i;
        }
    }

    public static synchronized IXDBServer[] getServers() {
        return servers;
    }

    public static synchronized IXDBServer getServer(String groupName) {
        try {
            int i = 0;
            while (i < servers.length) {
                if (servers[i].getGroup().equals(groupName)) {
                    return servers[i];
                }
                ++i;
            }
        }
        catch (XDBException exception) {}
        return null;
    }

    public static synchronized void addListener(IXDBServersListener listener) {
        listeners = (IXDBServersListener[])ArrayUtil.addElement(listeners, listener);
    }

    public static synchronized void removeListener(IXDBServersListener listener) {
        listeners = (IXDBServersListener[])ArrayUtil.removeElement(listeners, listener);
    }
}

