/*
 * Decompiled with CFR 0.152.
 */
package electric.xdb.server;

import electric.glue.IGLUELoggingConstants;
import electric.util.Context;
import electric.util.file.FileUtil;
import electric.util.log.ILoggingConstants;
import electric.util.log.Log;
import electric.xdb.Data;
import electric.xdb.XDBException;
import electric.xdb.server.IXDBLoader;
import electric.xdb.server.IXDBServer;
import electric.xdb.server.XDBCreator;
import electric.xdb.server.XDBServer;
import electric.xdb.store.IStore;
import electric.xdb.store.factory.IStoreFactory;
import electric.xdb.store.filesource.FileSource;
import electric.xdb.store.memory.MemoryStore;
import java.io.File;

public class FileLoader
implements IXDBLoader,
IStoreFactory,
IGLUELoggingConstants {
    private IXDBLoader loader = new XDBCreator();
    private String root;
    private boolean delete;
    private File[] groupDirectories;

    public FileLoader(String root, boolean delete) {
        this.root = root;
        this.delete = delete;
        File directory = new File(root);
        if (delete) {
            if (directory.exists()) {
                FileUtil.delete(directory, true);
            }
            directory.mkdirs();
        } else if (!directory.exists()) {
            directory.mkdirs();
        }
        this.groupDirectories = FileUtil.listFiles(directory);
        System.out.println("FILE LOADER STARTED");
        System.out.println("groupDirectories = " + this.groupDirectories.length);
        int i = 0;
        while (i < this.groupDirectories.length) {
            System.out.println("groupDirectories " + i + " = " + this.groupDirectories[i]);
            ++i;
        }
    }

    public String[] getGroups() {
        String[] names = new String[this.groupDirectories.length];
        int i = 0;
        while (i < this.groupDirectories.length) {
            names[i] = this.groupDirectories[i].getName();
            ++i;
        }
        return names;
    }

    public IXDBServer loadServer(String groupName, int replicationFactor, String[] urls, Context context, Data[] data, boolean xxx) throws XDBException {
        int i = 0;
        while (i < this.groupDirectories.length) {
            if (this.groupDirectories[i].getName().equals(groupName)) {
                return this.loadServerFrom(this.groupDirectories[i], xxx);
            }
            ++i;
        }
        System.out.println("NOT FOUND IN FILE SYSTEM: CREATE NEW ONE " + groupName);
        return this.loader.loadServer(groupName, replicationFactor, urls, context, data, xxx);
    }

    private IXDBServer loadServerFrom(File directory, boolean xxx) {
        System.out.println("LOAD SERVER FROM " + directory);
        FileSource dataSource = new FileSource(directory.getAbsolutePath(), false);
        MemoryStore dataStore = new MemoryStore(dataSource);
        if (Log.isLogging(ILoggingConstants.STARTUP_EVENT)) {
            Log.log(ILoggingConstants.STARTUP_EVENT, (Object)("loaded " + dataStore.getDataCount() + " records from " + directory));
        }
        XDBServer server = new XDBServer(dataStore);
        if (Log.isLogging(ILoggingConstants.STARTUP_EVENT)) {
            Log.log(ILoggingConstants.STARTUP_EVENT, (Object)("restart " + server));
        }
        System.out.println("RESTART SERVER " + server.getGroup());
        if (xxx) {
            server.restart();
        } else {
            server.start();
        }
        System.out.println("RETURN SERVER " + server.getGroup());
        return server;
    }

    public IStore newStore(String name, String group) {
        String path = this.root + File.separator + group;
        FileSource dataSource = new FileSource(path, this.delete);
        return new MemoryStore(dataSource);
    }
}

