/*
 * Decompiled with CFR 0.152.
 */
package electric.xdb.client;

import electric.util.log.Log;
import electric.xdb.Action;
import electric.xdb.Data;
import electric.xdb.GroupInfo;
import electric.xdb.IXDBConstants;
import electric.xdb.Id;
import electric.xdb.Query;
import electric.xdb.Result;
import electric.xdb.ServerInfo;
import electric.xdb.XDBException;
import electric.xdb.client.IXDBClient;
import electric.xdb.client.XDBProxy;
import electric.xdb.server.ClientDelta;
import electric.xdb.server.IXDBServer;
import electric.xdb.store.IStore;
import electric.xdb.store.memory.MemoryStore;
import electric.xdb.store.selectors.EnvelopeSelector;
import java.util.Vector;

public class XDBClient
implements IXDBClient,
IXDBConstants {
    private String group;
    private IStore cache = new MemoryStore();
    private XDBProxy proxy;

    public XDBClient(String group) {
        this.group = group;
        this.proxy = new XDBProxy(this);
    }

    public String toString() {
        return "XDBClient( group=" + this.group + ", serverURL=" + this.getServerURL() + ", cache size=" + this.cache.getDataCount() + " )";
    }

    public String getServerURL() {
        return this.proxy.getURL();
    }

    public IXDBServer getServer() {
        return this.proxy.getServer();
    }

    public ServerInfo getServerInfo() throws XDBException {
        return this.getServer().getServerInfo();
    }

    public String getGroup() {
        return this.group;
    }

    public GroupInfo getGroupInfo() throws XDBException {
        return this.getServer().getGroupInfo();
    }

    public void addData(Data data) throws XDBException {
        this.addDataArray(new Data[]{data});
    }

    public void addDataArray(Data[] data) throws XDBException {
        if (data.length == 0) {
            return;
        }
        Id[] ids = new Id[data.length];
        int i = 0;
        while (i < data.length) {
            ids[i] = data[i].getId();
            ++i;
        }
        IXDBServer server = this.getServer();
        Id[] missingIds = server.getMissingIds(ids);
        if (missingIds != null) {
            Data[] missingData = this.getData(data, missingIds);
            server.addDataArray(missingData);
            if (Log.isLogging(IXDBConstants.XDB_CLIENT_EVENT)) {
                Log.log(IXDBConstants.XDB_CLIENT_EVENT, (Object)("uploaded " + missingData.length + " data to " + this.getServerURL()));
            }
        }
        this.cache.addDataArray(data);
    }

    private Data[] getData(Data[] data, Id[] ids) {
        Vector<Data> vector = new Vector<Data>();
        int i = 0;
        while (i < ids.length) {
            int j = 0;
            while (j < data.length) {
                if (data[j].getId().equals(ids[i])) {
                    vector.addElement(data[j]);
                    break;
                }
                ++j;
            }
            ++i;
        }
        Object[] array = new Data[vector.size()];
        vector.copyInto(array);
        return array;
    }

    public int getDataCount() throws XDBException {
        return this.getServer().getDataCount();
    }

    public int getDataCountForQuery(Query query) throws XDBException {
        return this.getServer().getDataCountForQuery(query);
    }

    public Data[] getAllData() throws XDBException {
        return this.getDataForQuery(Query.getAllData());
    }

    public Data[] getDataForQuery(Query query) throws XDBException {
        Data[] dataToAdd;
        EnvelopeSelector selector = new EnvelopeSelector(query.getEnvelope());
        Id[] ids = this.cache.getIdsForSelector(selector);
        ClientDelta update = this.getServer().getDataForClient(query, ids);
        if (update == null) {
            return this.cache.getDataForIds(ids);
        }
        String[] keysToFlush = update.getKeysToFlush();
        if (keysToFlush != null) {
            this.cache.flushDataForKeys(keysToFlush);
            if (Log.isLogging(IXDBConstants.XDB_CLIENT_EVENT)) {
                Log.log(IXDBConstants.XDB_CLIENT_EVENT, (Object)("flushed " + keysToFlush.length + " data from cache"));
            }
        }
        if ((dataToAdd = update.getDataToAdd()) != null) {
            this.cache.addDataArray(dataToAdd);
            if (Log.isLogging(IXDBConstants.XDB_CLIENT_EVENT)) {
                Log.log(IXDBConstants.XDB_CLIENT_EVENT, (Object)("downloaded " + dataToAdd.length + " data from " + this.getServerURL()));
            }
        }
        return this.cache.getDataForSelector(selector);
    }

    public Data getDataForKey(String key) throws XDBException {
        Data[] data = this.getDataForQuery(Query.getDataWithKey(key));
        return data.length == 0 ? null : data[0];
    }

    public Data[] getDataForKeys(String[] keys) throws XDBException {
        Vector<Data> vector = new Vector<Data>();
        int i = 0;
        while (i < keys.length) {
            Data data = this.getDataForKey(keys[i]);
            if (data != null) {
                vector.addElement(data);
            }
            ++i;
        }
        Object[] array = new Data[vector.size()];
        vector.copyInto(array);
        return array;
    }

    public String[] getAllKeys() throws XDBException {
        return this.getServer().getAllKeys();
    }

    public void removeAllData() throws XDBException {
        this.cache.flushAllData();
        this.getServer().removeAllData();
    }

    public void removeDataForQuery(Query query) throws XDBException {
        this.cache.flushDataForSelector(new EnvelopeSelector(query.getEnvelope()));
        this.getServer().removeDataForQuery(query);
    }

    public void removeDataForKey(String key) throws XDBException {
        this.removeDataForKeys(new String[]{key});
    }

    public void removeDataForKeys(String[] keys) throws XDBException {
        this.cache.flushDataForKeys(keys);
        this.getServer().removeDataForKeys(keys);
    }

    public void dieUpdate(String[] keys, long dieAt) throws XDBException {
        this.getServer().dieUpdate(keys, dieAt);
    }

    public Result perform(Action action) throws XDBException {
        return this.getServer().perform(action);
    }
}

