/*
 * Decompiled with CFR 0.152.
 */
package electric.wsdl.parser;

import electric.glue.IGLUEContextConstants;
import electric.util.Context;
import electric.util.XURL;
import electric.util.resourceloader.ResourceLoaders;
import electric.util.string.Strings;
import electric.wsdl.IWSDLConstants;
import electric.wsdl.Message;
import electric.wsdl.PortType;
import electric.wsdl.Service;
import electric.wsdl.WSDL;
import electric.wsdl.WSDLException;
import electric.wsdl.WSDLFactories;
import electric.wsdl.util.EncodingStyleUtil;
import electric.xml.Attribute;
import electric.xml.Attributes;
import electric.xml.Document;
import electric.xml.Element;
import electric.xml.Elements;
import electric.xml.ParseException;
import electric.xml.io.Namespaces;
import electric.xml.io.schema.Schema;
import electric.xml.io.schema.SchemaException;
import electric.xml.io.schema.SchemaProperties;
import java.io.IOException;

public class WSDLParser
implements IGLUEContextConstants,
IWSDLConstants {
    public static WSDL newWSDL(String path, Context context) throws WSDLException, ParseException, IOException {
        return WSDLParser.newWSDL(path, new Document(ResourceLoaders.loadResource(path, context)), context);
    }

    public static WSDL newWSDL(String path, Document document, Context context) throws WSDLException, ParseException, IOException {
        WSDL wsdl = new WSDL();
        wsdl.setPath(path);
        wsdl.setDocument(document);
        Element definitions = document.getRoot();
        wsdl.setName(definitions.getAttributeValue("name"));
        wsdl.setTargetNamespace(definitions.getAttributeValue("targetNamespace"));
        if (wsdl.getTargetNamespace() == null) {
            throw new WSDLException("missing targetNamespace");
        }
        wsdl.setEncodingStyle(EncodingStyleUtil.findEncodingStyle(context, document));
        Namespaces namespaces = new Namespaces(WSDLParser.getVersion(definitions), wsdl.getEncodingStyle());
        namespaces.setEnforceEncodingStyle(false);
        wsdl.setNamespaces(namespaces);
        WSDLParser.parseWSDL(wsdl, definitions, path, context, namespaces);
        return wsdl;
    }

    private static void parseWSDL(WSDL wsdl, Element definitions, String path, Context context, Namespaces namespaces) throws ParseException, SchemaException, IOException, WSDLException {
        String targetNamespace = definitions.getAttributeValue("targetNamespace");
        Elements imports = definitions.getElements("import");
        while (imports.hasMoreElements()) {
            Element element = imports.next();
            String importNamespace = element.getAttributeValue("namespace");
            String location = element.getAttributeValue("location");
            if (!XURL.hasProtocol(location)) {
                location = Strings.splice(Strings.getEndpoint(path), location);
            }
            WSDLParser.parseImport(wsdl, importNamespace, location, context, namespaces);
        }
        Element types = definitions.getElement("types");
        if (types != null) {
            Elements schemas = types.getElements("schema");
            while (schemas.hasMoreElements()) {
                WSDLParser.parseSchema(namespaces, schemas.next());
            }
        }
        Elements messages = definitions.getElements("message");
        while (messages.hasMoreElements()) {
            namespaces.addItem(new Message(wsdl, targetNamespace, messages.next()));
        }
        Elements portTypes = definitions.getElements("portType");
        while (portTypes.hasMoreElements()) {
            namespaces.addItem(new PortType(wsdl, targetNamespace, portTypes.next()));
        }
        Elements bindings = definitions.getElements("binding");
        while (bindings.hasMoreElements()) {
            namespaces.addItem(WSDLFactories.newBinding(wsdl, targetNamespace, bindings.next()));
        }
        Elements services = definitions.getElements("service");
        while (services.hasMoreElements()) {
            namespaces.addItem(new Service(wsdl, targetNamespace, services.next()));
        }
    }

    private static void parseImport(WSDL wsdl, String namespace, String location, Context context, Namespaces namespaces) throws IOException, ParseException, WSDLException {
        Document document = new Document(ResourceLoaders.loadResource(location, context));
        Element definitions = document.getRoot();
        if (definitions.getName().equals("definitions")) {
            WSDLParser.parseWSDL(wsdl, definitions, location, context, namespaces);
        } else if (definitions.getName().equals("schema")) {
            WSDLParser.parseSchema(namespaces, definitions);
        } else {
            throw new WSDLException("can only import <definitions> or <schema>");
        }
    }

    private static void parseSchema(Namespaces namespaces, Element schema) throws SchemaException {
        Schema cachedSchema;
        String tns = schema.getAttribute("targetNamespace");
        if (tns == null) {
            tns = "";
        }
        if ((cachedSchema = namespaces.getSchema(tns)) == null) {
            new Schema(namespaces, schema);
        } else {
            cachedSchema.parseSchema(schema);
        }
    }

    private static String getVersion(Element definitions) {
        Element types = definitions.getElement("types");
        String[] XSDS = SchemaProperties.getXSDS();
        if (types != null) {
            int i = 0;
            while (i < XSDS.length) {
                if (types.getElements(XSDS[i], "schema").hasMoreElements()) {
                    return XSDS[i];
                }
                ++i;
            }
        }
        Attributes attributes = definitions.getAttributeObjects();
        while (attributes.hasMoreElements()) {
            Attribute attribute = attributes.next();
            int i = 0;
            while (i < XSDS.length) {
                if (attribute.getValue().equals(XSDS[i])) {
                    return XSDS[i];
                }
                ++i;
            }
        }
        return SchemaProperties.getDefaultSchema();
    }
}

