/*
 * Decompiled with CFR 0.152.
 */
package electric.wsdl.loader;

import electric.registry.Registry;
import electric.registry.RegistryException;
import electric.server.IServer;
import electric.server.Servers;
import electric.service.IService;
import electric.util.Context;
import electric.util.XURL;
import electric.util.string.Strings;
import electric.util.thread.Lock;
import electric.wsdl.WSDL;
import electric.wsdl.WSDLException;
import electric.wsdl.parser.WSDLParser;
import electric.xml.ParseException;
import java.io.IOException;
import java.util.Hashtable;

public final class WSDLLoader {
    private static Hashtable pathToWSDL = new Hashtable();

    public static WSDL getWSDL(String path) throws IOException, ParseException, RegistryException, WSDLException {
        return WSDLLoader.getWSDL(path, new Context());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static WSDL getWSDL(String path, Context context) throws IOException, ParseException, RegistryException, WSDLException {
        WSDL wsdl;
        WSDL wSDL = wsdl = path.indexOf("noWsdlCache") != -1 ? null : WSDLLoader.getFromCache(path);
        if (wsdl != null) {
            return wsdl;
        }
        Lock lock = Lock.obtain("wsdl-" + path);
        try {
            XURL xurl = new XURL(path);
            IServer server = Servers.getServerForPath(xurl);
            if (server != null) {
                String urn = server.getLocalPath(Strings.head(xurl.getFile(), '.'));
                IService service = (IService)Registry.get(urn);
                wsdl = service.getWSDL();
            } else if (xurl.getProtocol().equals("soaplocal")) {
                IService service = (IService)Registry.get(xurl.getFile());
                wsdl = service.getWSDL();
            } else {
                wsdl = WSDLParser.newWSDL(path, context);
            }
            WSDLLoader.addToCache(path, wsdl);
            WSDL wSDL2 = wsdl;
            Object var9_8 = null;
            lock.release();
            return wSDL2;
        }
        catch (Throwable throwable) {
            Object var9_9 = null;
            lock.release();
            throw throwable;
        }
    }

    public static synchronized void clearCache() {
        pathToWSDL = new Hashtable();
    }

    public static synchronized boolean removeFromCache(String path) {
        return pathToWSDL.remove(path) != null;
    }

    public static synchronized WSDL getFromCache(String path) {
        return (WSDL)pathToWSDL.get(path);
    }

    public static synchronized void addToCache(String path, WSDL wsdl) {
        pathToWSDL.put(path, wsdl);
    }
}

