/*
 * Decompiled with CFR 0.152.
 */
package electric.wsdl.handler;

import electric.glue.IGLUELoggingConstants;
import electric.registry.Registry;
import electric.registry.RegistryException;
import electric.server.http.IServletHandler;
import electric.server.http.ServletServer;
import electric.service.IService;
import electric.servlet.util.HTTPServletUtil;
import electric.soap.ISOAPConstants;
import electric.util.array.ByteArray;
import electric.util.http.IHTTPConstants;
import electric.util.io.FastByteArrayOutputStream;
import electric.util.io.Streams;
import electric.util.log.ILoggingConstants;
import electric.util.log.Log;
import electric.util.string.Strings;
import electric.wsdl.IWSDLConstants;
import electric.wsdl.WSDL;
import electric.wsdl.handler.InterfaceWriter;
import electric.xml.Document;
import java.io.IOException;
import java.io.PrintStream;
import java.io.Writer;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public final class WSDLHandler
implements IServletHandler,
IHTTPConstants,
IGLUELoggingConstants,
IWSDLConstants,
ISOAPConstants {
    static /* synthetic */ Class class$electric$wsdl$handler$WSDLHandler;

    public static void startup() {
        ServletServer.addHandlerType(class$electric$wsdl$handler$WSDLHandler == null ? (class$electric$wsdl$handler$WSDLHandler = WSDLHandler.class$("electric.wsdl.handler.WSDLHandler")) : class$electric$wsdl$handler$WSDLHandler);
    }

    public void init(ServletServer server) {
    }

    public boolean service(ServletServer server, HttpServletRequest request, HttpServletResponse response) throws IOException {
        if (server.getRoot() == null) {
            return false;
        }
        String pathInfo = request.getPathInfo();
        if (pathInfo == null || !pathInfo.toLowerCase().endsWith(".wsdl")) {
            return false;
        }
        String path = Strings.splice(server.getRoot(), pathInfo);
        String urn = Strings.head(path, '.');
        ByteArray byteArray = null;
        if (Log.isLogging(IGLUELoggingConstants.HTTP_EVENT)) {
            Log.log(IGLUELoggingConstants.HTTP_EVENT, (Object)("request from " + request.getRemoteHost() + "\n" + request + "\n"));
        }
        try {
            Object object = Registry.get(urn);
            if (!(object instanceof IService)) {
                return false;
            }
            WSDL wsdl = ((IService)object).getWSDL();
            byteArray = this.getByteArray(wsdl, request.getQueryString());
            response.setContentType("text/xml");
            response.setStatus(200);
        }
        catch (RegistryException exception) {
            if (Log.isLogging(ILoggingConstants.EXCEPTION_EVENT)) {
                Log.log(ILoggingConstants.EXCEPTION_EVENT, (Throwable)exception);
            }
            return false;
        }
        catch (Exception exception) {
            FastByteArrayOutputStream output = new FastByteArrayOutputStream();
            exception.printStackTrace(new PrintStream(output));
            byteArray = output.getByteArray();
            response.setContentType("text/html");
            response.setStatus(404);
        }
        response.setHeader("Server", IHTTPConstants.SERVER_TYPE);
        HTTPServletUtil.writeContent(request, response, byteArray);
        return true;
    }

    private ByteArray getByteArray(WSDL wsdl, String queryString) throws IOException {
        if (queryString != null && queryString.indexOf("interface") != -1) {
            return this.getInterfaceByteArray(wsdl);
        }
        return this.getImplementationByteArray(wsdl);
    }

    private ByteArray getImplementationByteArray(WSDL wsdl) throws IOException {
        return wsdl.getDocument().getByteArray();
    }

    private ByteArray getInterfaceByteArray(WSDL wsdl) throws IOException {
        Document document = wsdl.getDocument();
        FastByteArrayOutputStream stream = new FastByteArrayOutputStream();
        Writer writer = Streams.getWriter(stream, document.getEncoding());
        InterfaceWriter interfaceWriter = new InterfaceWriter(writer, -1, true);
        interfaceWriter.write(document);
        interfaceWriter.flush();
        return stream.getByteArray();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

