/*
 * Decompiled with CFR 0.152.
 */
package electric.wsdl;

import electric.wsdl.Binding;
import electric.wsdl.IWSDLFactory;
import electric.wsdl.Port;
import electric.wsdl.Service;
import electric.wsdl.WSDL;
import electric.wsdl.WSDLException;
import electric.wsdl.WSDLFactory;
import electric.xml.Element;
import electric.xml.io.schema.SchemaException;
import java.util.Enumeration;
import java.util.Hashtable;

public class WSDLFactories {
    private static final Hashtable protocolToFactory = new Hashtable();
    private static final WSDLFactory defaultFactory = new WSDLFactory();

    public static void addFactory(String protocol, IWSDLFactory factory) {
        protocolToFactory.put(protocol, factory);
    }

    public static IWSDLFactory getFactory(String protocol) {
        return (IWSDLFactory)protocolToFactory.get(protocol);
    }

    public static void removeFactory(String protocol) {
        protocolToFactory.remove(protocol);
    }

    public static Binding newBinding(WSDL wsdl, String targetNamespace, Element element) throws WSDLException, SchemaException {
        Enumeration factories = protocolToFactory.elements();
        while (factories.hasMoreElements()) {
            Binding binding = ((IWSDLFactory)factories.nextElement()).newBinding(wsdl, targetNamespace, element, "http://schemas.xmlsoap.org/wsdl/soap/");
            if (binding == null) continue;
            return binding;
        }
        return defaultFactory.newBinding(wsdl, targetNamespace, element, "http://schemas.xmlsoap.org/wsdl/soap/");
    }

    public static Port newPort(Service service, Element element) throws WSDLException, SchemaException {
        Enumeration factories = protocolToFactory.elements();
        while (factories.hasMoreElements()) {
            Port port = ((IWSDLFactory)factories.nextElement()).newPort(service, element);
            if (port == null) continue;
            return port;
        }
        return defaultFactory.newPort(service, element);
    }
}

