/*
 * Decompiled with CFR 0.152.
 */
package electric.wsdl;

import electric.util.XURL;
import electric.wsdl.Binding;
import electric.wsdl.IWSDLConstants;
import electric.wsdl.Service;
import electric.wsdl.WSDLException;
import electric.xml.Element;
import electric.xml.io.schema.SchemaException;
import java.net.MalformedURLException;

public class Port
implements IWSDLConstants {
    protected Service service;
    protected String name;
    protected Binding binding;
    protected XURL endpoint;

    public Port(Service service, Element port) throws WSDLException, SchemaException {
        this.service = service;
        this.name = port.getAttributeValue("name");
        if (this.name == null) {
            throw new WSDLException("<port> is missing name attribute");
        }
        String bindingName = port.getAttributeValue("binding");
        if (bindingName == null) {
            throw new WSDLException("<port> is missing binding attribute");
        }
        this.binding = service.getWSDL().getBinding(port.getQName(bindingName));
    }

    public Port(Service service, Binding binding, String name, XURL endpoint) {
        this.service = service;
        this.binding = binding;
        this.name = name;
        this.endpoint = endpoint;
    }

    public String toString() {
        return "Port( " + this.name + " )";
    }

    public String getName() {
        return this.name;
    }

    public Service getService() {
        return this.service;
    }

    public Binding getBinding() {
        return this.binding;
    }

    public XURL getEndpoint() {
        return this.endpoint;
    }

    public void setEndpoint(XURL endpoint) {
        this.endpoint = endpoint;
    }

    public void setEndpoint(String xurl) throws MalformedURLException {
        this.endpoint = new XURL(xurl);
    }

    public Element writeWSDL(Element service) {
        String wsdlPrefix = service.getNamespacePrefix("http://schemas.xmlsoap.org/wsdl/");
        Element port = service.addElement(wsdlPrefix, "port");
        port.setAttribute("name", this.name);
        port.setAttribute("binding", "tns:" + this.binding.getName());
        return port;
    }
}

