/*
 * Decompiled with CFR 0.152.
 */
package electric.wsdl;

import electric.util.array.ArrayUtil;
import electric.util.reflect.IOperation;
import electric.util.reflect.OperationLookup;
import electric.wsdl.WSDL;
import java.lang.reflect.Method;
import java.util.Hashtable;

public final class Operations {
    private WSDL wsdl;
    private Hashtable nameToOperations = new Hashtable();
    private Hashtable methodToOperation = new Hashtable();

    public Operations(WSDL wsdl) {
        this.wsdl = wsdl;
    }

    public WSDL getWSDL() {
        return this.wsdl;
    }

    public void addOperations(IOperation[] operations) {
        int i = 0;
        while (i < operations.length) {
            IOperation operation = operations[i];
            String name = operation.getMethodName();
            IOperation[] array = (IOperation[])this.nameToOperations.get(name);
            if (array == null) {
                this.nameToOperations.put(name, new IOperation[]{operation});
            } else {
                this.nameToOperations.put(name, ArrayUtil.addElement(array, operation));
            }
            ++i;
        }
    }

    public synchronized IOperation getOperation(Method method) throws NoSuchMethodException {
        IOperation operation = (IOperation)this.methodToOperation.get(method);
        if (operation != null) {
            return operation;
        }
        operation = this.getOperation(method.getName(), method.getParameterTypes());
        this.methodToOperation.put(method, operation);
        return operation;
    }

    public IOperation getOperation(String methodName, Class[] argClasses) throws NoSuchMethodException {
        return OperationLookup.getOperation(this.getOperations(methodName), methodName, argClasses);
    }

    public IOperation getOperation(String methodName, Class[] inArgClasses, boolean isAsync) throws NoSuchMethodException {
        return OperationLookup.getOperation(this.getOperations(methodName), methodName, inArgClasses, isAsync);
    }

    public IOperation getOperation(String methodName, int argCount) throws NoSuchMethodException {
        return OperationLookup.getOperation(this.getOperations(methodName), methodName, argCount);
    }

    public IOperation getOperation(String methodName, int inArgCount, boolean isAsync) throws NoSuchMethodException {
        return OperationLookup.getOperationsWithExactArguments(this.getOperations(methodName), inArgCount, isAsync)[0];
    }

    public IOperation[] getOperations(String methodName) throws NoSuchMethodException {
        IOperation[] operations = (IOperation[])this.nameToOperations.get(methodName);
        if (operations == null) {
            throw new NoSuchMethodException(methodName);
        }
        return operations;
    }
}

