/*
 * Decompiled with CFR 0.152.
 */
package electric.webserver.messages.ssl;

import electric.glue.IGLUELoggingConstants;
import electric.net.channel.IChannel;
import electric.net.socket.SocketChannel;
import electric.servlet.InboundHTTPRequest;
import electric.servlet.OutboundHTTPResponse;
import electric.util.http.IHTTPConstants;
import electric.util.log.ILoggingConstants;
import electric.util.log.Log;
import electric.webserver.messages.IMessageFactory;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import javax.net.ssl.SSLSession;
import javax.net.ssl.SSLSocket;
import javax.security.cert.CertificateEncodingException;

public class SSLMessageFactory
implements IMessageFactory,
IHTTPConstants,
IGLUELoggingConstants {
    private static boolean convertCertificates = true;

    public boolean matches(String protocol) {
        return "https".equalsIgnoreCase(protocol);
    }

    public InboundHTTPRequest createRequest(IChannel channel) throws IOException {
        SocketChannel socketChannel = (SocketChannel)channel;
        SSLSocket sslSocket = (SSLSocket)socketChannel.getSocket();
        InboundHTTPRequest request = new InboundHTTPRequest(socketChannel);
        request.readHeaders();
        SSLSession session = sslSocket.getSession();
        request.setAttribute("javax.servlet.request.cipher_suite", session.getCipherSuite());
        request.setSecure(true);
        request.setScheme("https");
        if (sslSocket.getNeedClientAuth()) {
            this.configClientCerts(session, request);
        }
        return request;
    }

    public OutboundHTTPResponse createResponse(IChannel channel, InboundHTTPRequest request) {
        return new OutboundHTTPResponse(request);
    }

    public static void setConvertCertificates(boolean convertCertificates) {
        SSLMessageFactory.convertCertificates = convertCertificates;
    }

    private void configClientCerts(SSLSession session, InboundHTTPRequest request) {
        Object[] certChain = null;
        certChain = convertCertificates ? SSLMessageFactory.getConvertedCertChain(session) : SSLMessageFactory.getCertChain(session);
        if (certChain != null) {
            request.setAttribute("javax.servlet.request.X509Certificate", certChain);
        }
    }

    private static X509Certificate[] getConvertedCertChain(SSLSession session) {
        try {
            javax.security.cert.X509Certificate[] certs = SSLMessageFactory.getCertChain(session);
            if (certs == null) {
                return null;
            }
            X509Certificate[] convertedCerts = new X509Certificate[certs.length];
            int i = 0;
            while (i < certs.length) {
                convertedCerts[i] = SSLMessageFactory.convertCert(certs[i]);
                ++i;
            }
            return convertedCerts;
        }
        catch (Throwable exception) {
            String message = "ssl message factory, problem cert conversion error";
            if (Log.isLogging(ILoggingConstants.EXCEPTION_EVENT)) {
                Log.log(ILoggingConstants.EXCEPTION_EVENT, message, exception);
            }
            if (Log.isLogging(IGLUELoggingConstants.SECURITY_DETAIL_EVENT)) {
                Log.log(IGLUELoggingConstants.SECURITY_DETAIL_EVENT, (Object)message);
            }
            return null;
        }
    }

    private static javax.security.cert.X509Certificate[] getCertChain(SSLSession session) {
        try {
            return session.getPeerCertificateChain();
        }
        catch (Throwable exception) {
            block3: {
                String message = "ssl message factory, problem cert conversion error";
                if (Log.isLogging(ILoggingConstants.EXCEPTION_EVENT)) {
                    Log.log(ILoggingConstants.EXCEPTION_EVENT, message, exception);
                }
                if (!Log.isLogging(IGLUELoggingConstants.SECURITY_DETAIL_EVENT)) break block3;
                Log.log(IGLUELoggingConstants.SECURITY_DETAIL_EVENT, (Object)message);
            }
            return null;
        }
    }

    private static X509Certificate convertCert(javax.security.cert.X509Certificate cert) throws CertificateEncodingException, CertificateException {
        byte[] encodedCert = cert.getEncoded();
        CertificateFactory cf = CertificateFactory.getInstance("X.509");
        ByteArrayInputStream byteStream = new ByteArrayInputStream(encodedCert);
        return (X509Certificate)cf.generateCertificate(byteStream);
    }
}

