/*
 * Decompiled with CFR 0.152.
 */
package electric.webserver;

import electric.glue.IGLUELoggingConstants;
import electric.net.channel.IChannel;
import electric.net.channel.IChannelSink;
import electric.net.channel.IChannelStates;
import electric.net.socket.SocketChannel;
import electric.net.socket.SocketServer;
import electric.servlet.HTTPContext;
import electric.servlet.InboundHTTPRequest;
import electric.servlet.OutboundHTTPResponse;
import electric.servlet.ServletEngine;
import electric.servlet.util.HTTPServletUtil;
import electric.util.XURL;
import electric.util.encoding.StringEncodings;
import electric.util.http.HTTPUtil;
import electric.util.http.IHTTPConstants;
import electric.util.license.License;
import electric.util.license.LicensingException;
import electric.util.log.ILoggingConstants;
import electric.util.log.Log;
import electric.util.string.Strings;
import electric.util.thread.ThreadPool;
import electric.webserver.IWebServerConstants;
import electric.webserver.WebServers;
import electric.webserver.messages.IMessageFactory;
import electric.webserver.messages.MessageFactories;
import electric.webserver.messages.tcp.TCPMessageFactory;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public final class WebServer
implements IWebServerConstants,
IChannelSink,
IHTTPConstants,
IGLUELoggingConstants,
IChannelStates {
    private static int defaultTimeout = 15000;
    private ServletEngine servletEngine = new ServletEngine(this);
    private SocketServer socketServer;
    private XURL xurl;
    private int timeout = defaultTimeout;
    private IMessageFactory messageFactory;

    public WebServer(String url) throws IOException {
        this(url, ThreadPool.getShared(), SocketServer.getDefaultBacklog());
    }

    public WebServer(String url, ThreadPool threadPool, int backlog) throws IOException {
        if (License.isClientLicense()) {
            throw new LicensingException("webserver functionality is disabled. Contact TME Sales to obtain a server side license");
        }
        this.setTimeout(defaultTimeout);
        this.xurl = new XURL(url);
        XURL host = HTTPUtil.getTCPXURL(this.xurl);
        this.socketServer = new SocketServer(host, backlog, threadPool, this);
        if (this.xurl.getPort() == 0) {
            int port = this.socketServer.getXURL().getPort();
            this.xurl = new XURL(this.xurl.getProtocol(), this.xurl.getHost(), port, this.xurl.getFile(), this.xurl.getReference());
        }
        this.messageFactory = MessageFactories.getFactory(this.xurl.getProtocol());
        if (this.messageFactory == null) {
            if (Log.isLogging(ILoggingConstants.STARTUP_EVENT)) {
                Log.log(ILoggingConstants.STARTUP_EVENT, (Object)"could not locate request factory, falling back to SocketMessageFactory");
            }
            this.messageFactory = new TCPMessageFactory();
        }
    }

    public boolean service(IChannel channel) throws IOException {
        SocketChannel socketChannel = (SocketChannel)channel;
        socketChannel.setTimeout(this.timeout);
        InboundHTTPRequest request = this.messageFactory.createRequest(socketChannel);
        if (request == null) {
            this.respondToRejectedRequest(channel);
            return false;
        }
        channel.setState(0);
        socketChannel.setKeepAlive(request.isKeepAlive());
        OutboundHTTPResponse response = this.messageFactory.createResponse(channel, request);
        try {
            this.servletEngine.service(request.getRequestURI(), (ServletRequest)request, (ServletResponse)response);
            response.flushBuffer();
            if (response.getContentLength() == -1) {
                channel.close();
            }
            return true;
        }
        catch (Exception exception) {
            String message = Strings.replace(this.getMessage(exception), "\n", "<br>");
            this.returnErrorResponse(request, response, message, 500);
            return false;
        }
    }

    private void respondToRejectedRequest(IChannel channel) throws IOException {
        OutboundHTTPResponse response = this.messageFactory.createResponse(channel, null);
        if (response == null) {
            channel.close();
            if (Log.isLogging(IGLUELoggingConstants.HTTP_EVENT)) {
                Log.log(IGLUELoggingConstants.HTTP_EVENT, (Object)("request rejected from: " + channel.getRemoteXURL()));
            }
            return;
        }
        response.flushBuffer();
    }

    private void returnErrorResponse(InboundHTTPRequest request, OutboundHTTPResponse response, String message, int statusCode) throws IOException {
        response.setStatus(statusCode);
        response.resetStreams();
        response.setContentType("text/html");
        HTTPServletUtil.writeContent((HttpServletRequest)request, (HttpServletResponse)response, StringEncodings.toProtocolEncoding(message));
        response.flushBuffer();
    }

    private String getMessage(Throwable exception) {
        StringWriter message = new StringWriter();
        message.write("<html><body>");
        message.write("<font face=\"Courier\">");
        message.write("<b>");
        message.write(exception.toString());
        message.write("</b><br><br>");
        message.write("</body></html>");
        exception.printStackTrace(new PrintWriter(message));
        return message.toString();
    }

    public XURL getXURL() {
        return this.xurl;
    }

    public void startup() throws IOException {
        this.socketServer.startup();
        WebServers.addWebServer(this.xurl.getPort(), this);
    }

    public void shutdown() throws IOException {
        this.servletEngine.shutdown();
        this.socketServer.shutdown();
        WebServers.removeWebServer(this.xurl.getPort());
        if (Log.isLogging(ILoggingConstants.SHUTDOWN_EVENT)) {
            String logText = "webserver server stopped on " + this.xurl;
            Log.log(ILoggingConstants.SHUTDOWN_EVENT, (Object)logText);
        }
    }

    public void setDocbase(String docbase) {
        block2: {
            try {
                this.addContext("", new HTTPContext(docbase));
            }
            catch (ServletException exception) {
                if (!Log.isLogging(ILoggingConstants.EXCEPTION_EVENT)) break block2;
                Log.log(ILoggingConstants.EXCEPTION_EVENT, "exception during WebServer.setDocbase()", exception);
            }
        }
    }

    public void addWelcomeFile(String filename) {
        this.servletEngine.getContext("").addWelcomeFile(filename);
    }

    public void addContext(String path, HTTPContext context) throws ServletException {
        this.addContext(path, context, true);
    }

    public void addContext(String path, HTTPContext context, boolean startup) throws ServletException {
        this.servletEngine.addContext(path, context, startup);
    }

    public HTTPContext removeContext(String path) {
        return this.servletEngine.removeContext(path);
    }

    public HTTPContext getContext(String path) {
        return this.servletEngine.getContext(path);
    }

    public HTTPContext[] getAllContexts() {
        return this.servletEngine.getAllContexts();
    }

    public void setTimeout(int timeout) {
        this.timeout = timeout;
    }

    public int getTimeout() {
        return this.timeout;
    }

    public static void setDefaultTimeout(int defaultTimeout) {
        WebServer.defaultTimeout = defaultTimeout;
    }

    public static int getDefaultTimeout() {
        return defaultTimeout;
    }

    public SocketServer getSocketServer() {
        return this.socketServer;
    }

    public IMessageFactory getMessageFactory() {
        return this.messageFactory;
    }

    public void setMessageFactory(IMessageFactory messageFactory) {
        this.messageFactory = messageFactory;
    }
}

