/*
 * Decompiled with CFR 0.152.
 */
package electric.util.wml;

import electric.util.wml.IWMLConstants;
import electric.xml.DocType;
import electric.xml.Document;
import electric.xml.Element;
import electric.xml.Instruction;

public class WML
extends Element
implements IWMLConstants {
    private static final Instruction VERSION = new Instruction("xml", "version=\"1.0\"");
    private static DocType DOCTYPE = new DocType("wml");

    public WML() {
    }

    public WML(String name) {
        super(name);
    }

    public static WML newDocument() {
        Document document = new Document();
        document.addChild(VERSION);
        document.addChild(DOCTYPE);
        WML wml = new WML("wml");
        document.addChild(wml);
        return wml;
    }

    public WML card(String id) {
        WML element = this.newWML("card");
        element.setAttribute("id", id);
        return element;
    }

    public WML id(String string) {
        return this.newAttribute("id", string);
    }

    public WML title(String string) {
        return this.newAttribute("title", string);
    }

    public WML head() {
        return this.newWML("head");
    }

    public WML meta() {
        return this.newWML("meta");
    }

    public WML wml() {
        return this.newWML("wml");
    }

    public WML newline() {
        return this.newElement("br");
    }

    public WML paragraph() {
        return this.newWML("p");
    }

    public WML preformatted() {
        return this.newWML("pre");
    }

    public WML bold() {
        return this.newWML("b");
    }

    public WML big() {
        return this.newWML("big");
    }

    public WML emphasized() {
        return this.newWML("em");
    }

    public WML italic() {
        return this.newWML("i");
    }

    public WML small() {
        return this.newWML("small");
    }

    public WML strong() {
        return this.newWML("strong");
    }

    public WML underline() {
        return this.newWML("u");
    }

    public WML select(String name) {
        WML element = this.newWML("select");
        element.setAttribute("name", name);
        return element;
    }

    public WML option(String value) {
        WML element = this.newWML("option");
        element.setAttribute("value", value);
        return element;
    }

    public WML when(String type) {
        WML element = this.newWML("do");
        element.setAttribute("type", type);
        return element;
    }

    public WML go(String url) {
        WML element = this.newWML("go");
        element.setAttribute("href", url);
        return element;
    }

    public WML align(String type) {
        return this.newAttribute("align", type);
    }

    public WML text(String string) {
        this.addText(string);
        return this;
    }

    public String asString() {
        return this.getDocument().toString(-1);
    }

    private WML newWML(String name) {
        WML newWML = new WML(name);
        this.addChild(newWML);
        return newWML;
    }

    private WML newAttribute(String name, String value) {
        this.setAttribute(name, value);
        return this;
    }

    private WML newElement(String name) {
        this.addChild(new WML(name));
        return this;
    }

    static {
        DOCTYPE.setIds("-//WAPFORUM//DTD WML 1.1//EN", "http://www.wapforum.org/DTD/wml_1.1.xml");
    }
}

