/*
 * Decompiled with CFR 0.152.
 */
package electric.util.string;

import electric.util.encoding.StringEncodings;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public final class Base64 {
    public static String toBase64(byte[] bytes) {
        int x = bytes.length / 3;
        int remainder = bytes.length % 3;
        byte[] array = new byte[(remainder != 0 ? x + 1 : x) * 4];
        int z = 0;
        int j = 0;
        int i = 0;
        while (i < x) {
            array[z++] = Base64.toBase64((byte)(bytes[j] >> 2 & 0x3F));
            array[z++] = Base64.toBase64((byte)((bytes[j] & 3) << 4 | (bytes[j + 1] & 0xF0) >> 4 & 0xF));
            array[z++] = Base64.toBase64((byte)((bytes[j + 1] & 0xF) << 2 | (bytes[j + 2] & 0xC0) >> 6 & 3));
            array[z++] = Base64.toBase64((byte)(bytes[j + 2] & 0x3F));
            j += 3;
            ++i;
        }
        if (remainder == 1) {
            array[z++] = Base64.toBase64((byte)(bytes[j] >> 2 & 0x3F));
            array[z++] = Base64.toBase64((byte)((bytes[j] & 3) << 4));
            array[z++] = 61;
            array[z++] = 61;
        } else if (remainder == 2) {
            array[z++] = Base64.toBase64((byte)(bytes[j] >> 2 & 0x3F));
            array[z++] = Base64.toBase64((byte)((bytes[j] & 3) << 4 | (bytes[j + 1] & 0xF0) >> 4 & 0xF));
            array[z++] = Base64.toBase64((byte)((bytes[j + 1] & 0xF) << 2));
            array[z++] = 61;
        }
        return StringEncodings.fromProtocolEncoding(array);
    }

    public static String toBase64(Byte[] bytes) {
        int x = bytes.length / 3;
        int remainder = bytes.length % 3;
        byte[] array = new byte[(remainder != 0 ? x + 1 : x) * 4];
        int z = 0;
        int j = 0;
        int i = 0;
        while (i < x) {
            array[z++] = Base64.toBase64((byte)(bytes[j] >> 2 & 0x3F));
            array[z++] = Base64.toBase64((byte)((bytes[j] & 3) << 4 | (bytes[j + 1] & 0xF0) >> 4 & 0xF));
            array[z++] = Base64.toBase64((byte)((bytes[j + 1] & 0xF) << 2 | (bytes[j + 2] & 0xC0) >> 6 & 3));
            array[z++] = Base64.toBase64((byte)(bytes[j + 2] & 0x3F));
            j += 3;
            ++i;
        }
        if (remainder == 1) {
            array[z++] = Base64.toBase64((byte)(bytes[j] >> 2 & 0x3F));
            array[z++] = Base64.toBase64((byte)((bytes[j] & 3) << 4));
            array[z++] = 61;
            array[z++] = 61;
        } else if (remainder == 2) {
            array[z++] = Base64.toBase64((byte)(bytes[j] >> 2 & 0x3F));
            array[z++] = Base64.toBase64((byte)((bytes[j] & 3) << 4 | (bytes[j + 1] & 0xF0) >> 4 & 0xF));
            array[z++] = Base64.toBase64((byte)((bytes[j + 1] & 0xF) << 2));
            array[z++] = 61;
        }
        return StringEncodings.fromProtocolEncoding(array);
    }

    public static int getBase64Length(String string) {
        int length = string.length() / 4 * 3;
        if (string.length() > 0 && string.charAt(string.length() - 1) == '=') {
            length -= string.charAt(string.length() - 2) == '=' ? 2 : 1;
        }
        return length;
    }

    public static byte[] fromBase64(String string) {
        try {
            ByteArrayOutputStream baos = new ByteArrayOutputStream(Base64.getBase64Length(string));
            Base64.fromBase64(new ByteArrayInputStream(StringEncodings.toProtocolEncoding(string)), baos);
            return baos.toByteArray();
        }
        catch (IOException exception) {
            return new byte[0];
        }
    }

    public static byte toBase64(byte value) {
        if (value <= 25) {
            return (byte)(65 + value);
        }
        if (value <= 51) {
            return (byte)(97 + value - 26);
        }
        if (value <= 61) {
            return (byte)(48 + value - 52);
        }
        if (value == 62) {
            return 43;
        }
        if (value == 63) {
            return 47;
        }
        return 61;
    }

    public static byte fromBase64(byte value) {
        if (value >= 65 && value <= 90) {
            return (byte)(value - 65);
        }
        if (value >= 97 && value <= 122) {
            return (byte)(26 + value - 97);
        }
        if (value >= 48 && value <= 57) {
            return (byte)(52 + value - 48);
        }
        if (value == 43) {
            return 62;
        }
        if (value == 47) {
            return 63;
        }
        return 64;
    }

    public static void toBase64(InputStream in, OutputStream out) throws IOException {
        byte byte3;
        byte byte2;
        byte byte1;
        int bytes = 0;
        byte[] holder = new byte[3];
        byte[] nextByte = new byte[1];
        while (in.read(nextByte) == 1) {
            holder[bytes++] = nextByte[0];
            if (bytes != 3) continue;
            byte1 = Base64.toBase64((byte)(holder[0] >> 2 & 0x3F));
            byte2 = Base64.toBase64((byte)((holder[0] & 3) << 4 | (holder[1] & 0xF0) >> 4 & 0xF));
            byte3 = Base64.toBase64((byte)((holder[1] & 0xF) << 2 | (holder[2] & 0xC0) >> 6 & 3));
            byte byte4 = Base64.toBase64((byte)(holder[2] & 0x3F));
            out.write(new byte[]{byte1, byte2, byte3, byte4});
            bytes = 0;
        }
        if (bytes == 1) {
            byte1 = Base64.toBase64((byte)(holder[0] >> 2 & 0x3F));
            byte2 = Base64.toBase64((byte)((holder[0] & 3) << 4));
            out.write(new byte[]{byte1, byte2, 61, 61});
        } else if (bytes == 2) {
            byte1 = Base64.toBase64((byte)(holder[0] >> 2 & 0x3F));
            byte2 = Base64.toBase64((byte)((holder[0] & 3) << 4 | (holder[1] & 0xF0) >> 4 & 0xF));
            byte3 = Base64.toBase64((byte)((holder[1] & 0xF) << 2));
            out.write(new byte[]{byte1, byte2, byte3, 61});
        }
    }

    public static void fromBase64(InputStream in, OutputStream out) throws IOException {
        int bytes = 0;
        byte[] holder = new byte[4];
        byte[] nextByte = new byte[1];
        while (in.read(nextByte) == 1) {
            byte b3;
            byte b2;
            byte b1;
            if (Character.isLetterOrDigit((char)nextByte[0]) || (char)nextByte[0] == '+' || (char)nextByte[0] == '/') {
                holder[bytes++] = nextByte[0];
            }
            if ((char)nextByte[0] == '=') {
                if (bytes == 2) {
                    b1 = Base64.fromBase64(holder[0]);
                    b2 = Base64.fromBase64(holder[1]);
                    out.write(new byte[]{(byte)(b1 << 2 | (b2 & 0x30) >> 4)});
                    break;
                }
                if (bytes != 3) break;
                b1 = Base64.fromBase64(holder[0]);
                b2 = Base64.fromBase64(holder[1]);
                b3 = Base64.fromBase64(holder[2]);
                byte byte1 = (byte)(b1 << 2 | (b2 & 0x30) >> 4);
                byte byte2 = (byte)((b2 & 0xF) << 4 | (b3 & 0x3C) >> 2);
                out.write(new byte[]{byte1, byte2});
                break;
            }
            if (bytes != 4) continue;
            b1 = Base64.fromBase64(holder[0]);
            b2 = Base64.fromBase64(holder[1]);
            b3 = Base64.fromBase64(holder[2]);
            byte b4 = Base64.fromBase64(holder[3]);
            byte byte1 = (byte)(b1 << 2 | (b2 & 0x30) >> 4);
            byte byte2 = (byte)((b2 & 0xF) << 4 | (b3 & 0x3C) >> 2);
            byte byte3 = (byte)((b3 & 3) << 6 | b4 & 0x3F);
            out.write(new byte[]{byte1, byte2, byte3});
            bytes = 0;
        }
    }
}

