/*
 * Decompiled with CFR 0.152.
 */
package electric.util.reflect;

import electric.util.reflect.JavaComment;
import electric.util.reflect.Reflect;
import java.io.IOException;
import java.lang.reflect.Method;

public final class JavaMethod {
    public JavaComment comment;
    public String name;
    public String returnType;
    public String[] argTypes = new String[0];
    public String[] argNames = new String[0];
    public String[] exceptions = new String[0];

    public JavaMethod() {
    }

    public JavaMethod(String name, String[] argTypes, String[] argNames, String returnType, String[] exceptions, JavaComment comment) throws IOException {
        this.name = name;
        this.argTypes = argTypes;
        this.argNames = argNames;
        this.returnType = returnType;
        this.exceptions = exceptions;
        this.comment = comment;
    }

    public JavaMethod(Method method) {
        this.comment = new JavaComment();
        this.name = method.getName();
        this.returnType = Reflect.asString(method.getReturnType());
        Class<?>[] paramTypes = method.getParameterTypes();
        this.argTypes = new String[paramTypes.length];
        this.argNames = new String[paramTypes.length];
        int i = 0;
        while (i < this.argTypes.length) {
            this.argTypes[i] = Reflect.asString(paramTypes[i]);
            this.argNames[i] = "arg" + i;
            ++i;
        }
        Class<?>[] exceptionTypes = method.getExceptionTypes();
        this.exceptions = new String[exceptionTypes.length];
        int i2 = 0;
        while (i2 < exceptionTypes.length) {
            this.exceptions[i2] = exceptionTypes[i2].getName();
            ++i2;
        }
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        buffer.append(this.returnType);
        buffer.append(" ");
        buffer.append(this.name);
        if (this.argTypes.length == 0) {
            buffer.append("()");
        } else {
            buffer.append("( ");
            int i = 0;
            while (i < this.argTypes.length) {
                if (i > 0) {
                    buffer.append(", ");
                }
                buffer.append(this.argTypes[i]);
                buffer.append(" ");
                buffer.append(this.argNames[i]);
                ++i;
            }
            buffer.append(" )");
        }
        return buffer.toString();
    }

    public String getName() {
        return this.name;
    }

    public String[] getArgTypes() {
        return this.argTypes;
    }

    public String[] getArgNames() {
        return this.argNames;
    }

    public String getReturnType() {
        return this.returnType;
    }

    public JavaComment getComment() {
        return this.comment;
    }

    public boolean matches(Method method) {
        Class<?>[] parameterTypes = method.getParameterTypes();
        if (!method.getName().equals(this.name) || this.argTypes.length != parameterTypes.length) {
            return false;
        }
        int i = 0;
        while (i < parameterTypes.length) {
            String typeName1 = Reflect.asString(parameterTypes[i]);
            String typeName2 = this.argTypes[i];
            if (typeName1.indexOf(46) == -1 ? !typeName1.equals(typeName2) : !typeName1.endsWith(typeName2)) {
                return false;
            }
            ++i;
        }
        return true;
    }
}

