/*
 * Decompiled with CFR 0.152.
 */
package electric.util.mime;

import electric.util.Context;
import electric.util.array.ArrayUtil;
import electric.util.encoding.StringEncodings;
import electric.util.http.IHTTPConstants;
import electric.util.io.Streams;
import electric.util.log.ILoggingConstants;
import electric.util.log.Log;
import electric.util.mime.IDataHandler;
import electric.util.mime.IMIMEConstants;
import electric.util.mime.MIMEData;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.SequenceInputStream;
import java.util.Hashtable;
import java.util.StringTokenizer;

public class MIMEReader
implements ILoggingConstants,
IHTTPConstants,
IMIMEConstants {
    private boolean startPartInMemory = false;
    private MIMEData startPart;
    private MIMEData[] otherParts = new MIMEData[0];

    public MIMEReader(InputStream input, String contentType, String contentLocation, Context context) throws IOException {
        this(input, contentType, contentLocation, context, null);
    }

    /*
     * WARNING - void declaration
     */
    public MIMEReader(InputStream input, String contentType, String contentLocation, Context context, IDataHandler startPartHandler) throws IOException {
        int k;
        Hashtable<String, String> parameters = new Hashtable<String, String>();
        StringTokenizer tokenizer = new StringTokenizer(contentType, ";", false);
        while (tokenizer.hasMoreElements()) {
            String token = (String)tokenizer.nextElement();
            int index = token.indexOf("=");
            if (index == -1) continue;
            parameters.put(token.substring(0, index).toLowerCase().trim(), token.substring(index + 1).trim());
        }
        String delimiter = null;
        if (!parameters.containsKey("boundary")) {
            throw new IOException("missing boundary definition in Multipart/Related content type");
        }
        delimiter = (String)parameters.get("boundary");
        if (delimiter.startsWith("\"")) {
            delimiter = delimiter.substring(1);
        }
        if (delimiter.endsWith("\"")) {
            delimiter = delimiter.substring(0, delimiter.length() - 1);
        }
        delimiter = "--" + delimiter;
        parameters.put("boundary", delimiter);
        String startId = (String)parameters.get("start");
        if (startId.startsWith("\"")) {
            startId = startId.substring(1);
        }
        if (startId.endsWith("\"")) {
            startId = startId.substring(0, startId.length() - 1);
        }
        if (startId.startsWith("<")) {
            startId = startId.substring(1);
        }
        if (startId.endsWith(">")) {
            startId = startId.substring(0, startId.length() - 1);
        }
        while ((k = input.read()) != 10) {
            void var10_11;
            if (var10_11 != -1) continue;
            if (Log.isLogging(ILoggingConstants.ERROR_EVENT)) {
                Log.log(ILoggingConstants.ERROR_EVENT, (Object)"unable to read from input stream. client must have closed connection");
            }
            throw new IOException("input stream broken");
        }
        int chunkSize = (delimiter + "--").length();
        boolean lookForDelimiter = true;
        while (true) {
            if (lookForDelimiter) {
                String boundary = StringEncodings.fromProtocolEncoding(Streams.readUpTo(input, chunkSize));
                if (boundary.startsWith(delimiter + "--")) break;
                if (!boundary.startsWith(delimiter)) continue;
            }
            MIMEData mimeData = new MIMEData();
            mimeData.setBaseContentLocation(contentLocation);
            mimeData.setDelimiter(delimiter.getBytes());
            mimeData.readHeaders(input);
            if (mimeData.getContentLength() == -1) {
                lookForDelimiter = false;
            }
            if (startId == null) {
                startId = mimeData.getContentLabel();
            }
            if (mimeData.getContentLabel().equals(startId)) {
                if (startPartHandler != null) {
                    Context bodyContext = new Context();
                    bodyContext.setProperty("*/* dataHandler", startPartHandler);
                    mimeData.readContent(input, bodyContext);
                } else {
                    mimeData.readContent(input, context);
                }
                this.startPart = mimeData;
            } else {
                mimeData.readContent(input, context);
                this.otherParts = (MIMEData[])ArrayUtil.addElement(this.otherParts, mimeData);
            }
            byte[] twoBytes = new byte[2];
            if (!lookForDelimiter) {
                twoBytes[0] = (byte)input.read();
                twoBytes[1] = (byte)input.read();
                if (twoBytes[0] == 45 && twoBytes[1] == 45) break;
                input = new SequenceInputStream(new ByteArrayInputStream(twoBytes), input);
            }
            while ((k = input.read()) != 10) {
                if (k != -1) continue;
                if (Log.isLogging(ILoggingConstants.ERROR_EVENT)) {
                    Log.log(ILoggingConstants.ERROR_EVENT, (Object)"unable to read from input stream. client must have closed connection");
                }
                throw new IOException("input stream broken");
            }
            twoBytes[0] = (byte)input.read();
            twoBytes[1] = (byte)input.read();
            if (twoBytes[0] == 13 || twoBytes[1] == 10) continue;
            input = new SequenceInputStream(new ByteArrayInputStream(twoBytes), input);
        }
    }

    public MIMEData getStartPart() {
        return this.startPart;
    }

    public MIMEData[] getOtherParts() {
        return this.otherParts;
    }
}

