/*
 * Decompiled with CFR 0.152.
 */
package electric.util.mime;

import electric.util.encoding.StringEncodings;
import electric.util.http.IHTTPConstants;
import electric.util.io.Streams;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.text.ParsePosition;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Enumeration;
import java.util.Locale;
import java.util.TimeZone;
import java.util.Vector;

public final class MIMEHeaders
implements IHTTPConstants {
    private static final String[][] NO_HEADERS = new String[0][0];
    private static TimeZone gmt = TimeZone.getTimeZone("GMT");
    private static SimpleDateFormat dateFormatter1;
    private static SimpleDateFormat dateFormatter2;
    private static SimpleDateFormat dateFormatter3;
    public String[][] headers = NO_HEADERS;

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        int i = 0;
        while (i < this.headers.length) {
            buffer.append(this.headers[i][0]).append(": ").append(this.headers[i][1]).append('\n');
            ++i;
        }
        return buffer.toString();
    }

    public void readHeaders(InputStream inputStream) throws IOException {
        String line;
        while ((line = Streams.readLine(inputStream, StringEncodings.getProtocolEncoding())) != null && line.length() > 2) {
            int index = line.indexOf(58);
            if (index == -1) {
                throw new IOException("illegal HTTP header: " + line);
            }
            String name = line.substring(0, index).trim();
            String value = line.substring(index + 1, line.length()).trim();
            this.addHeader(name, value);
        }
    }

    public void writeHeaders(OutputStream output) throws IOException {
        int i = 0;
        while (i < this.headers.length) {
            output.write(this.headers[i][0].getBytes("ASCII"));
            output.write(IHTTPConstants.SEPARATOR);
            output.write(this.headers[i][1].getBytes("ASCII"));
            output.write(IHTTPConstants.EOL);
            ++i;
        }
    }

    public void clearHeaders() {
        this.headers = NO_HEADERS;
    }

    public String getHeader(String name) {
        int i = 0;
        while (i < this.headers.length) {
            if (name.equalsIgnoreCase(this.headers[i][0])) {
                return this.headers[i][1];
            }
            ++i;
        }
        return null;
    }

    public Enumeration getHeaders(String name) {
        Vector<String> values = new Vector<String>();
        int i = 0;
        while (i < this.headers.length) {
            if (name.equalsIgnoreCase(this.headers[i][0])) {
                values.addElement(this.headers[i][1]);
            }
            ++i;
        }
        return values.elements();
    }

    public boolean containsHeader(String name) {
        return this.getHeader(name) != null;
    }

    public Enumeration getHeaderNames() {
        Vector<String> names = new Vector<String>();
        int i = 0;
        while (i < this.headers.length) {
            if (!names.contains(this.headers[i][0])) {
                names.addElement(this.headers[i][0]);
            }
            ++i;
        }
        return names.elements();
    }

    public void setHeader(String name, String value) {
        int i = 0;
        while (i < this.headers.length) {
            if (name.equalsIgnoreCase(this.headers[i][0])) {
                this.headers[i][0] = name;
                this.headers[i][1] = value;
                return;
            }
            ++i;
        }
        this.addHeader(name, value);
    }

    public void addHeader(String name, String value) {
        String[][] newHeaders = new String[this.headers.length + 1][];
        System.arraycopy(this.headers, 0, newHeaders, 0, this.headers.length);
        newHeaders[this.headers.length] = new String[]{name, value};
        this.headers = newHeaders;
    }

    public void addHeaders(MIMEHeaders mimeHeaders) {
        String[][] newHeaders = new String[this.headers.length + mimeHeaders.headers.length][];
        System.arraycopy(this.headers, 0, newHeaders, 0, this.headers.length);
        int i = 0;
        while (i < mimeHeaders.headers.length) {
            newHeaders[this.headers.length + i] = mimeHeaders.headers[i];
            ++i;
        }
        this.headers = newHeaders;
    }

    public String removeHeader(String name) {
        int i = 0;
        while (i < this.headers.length) {
            if (this.headers[i][0].equals(name)) {
                String value = this.headers[i][1];
                int length = this.headers.length;
                String[][] newHeaders = new String[length - 1][];
                System.arraycopy(this.headers, 0, newHeaders, 0, i);
                System.arraycopy(this.headers, i + 1, newHeaders, i, length - i - 1);
                this.headers = newHeaders;
                return value;
            }
            ++i;
        }
        return null;
    }

    public void removeHeaders(String name) {
        while (this.removeHeader(name) != null) {
        }
    }

    public int getIntHeader(String name) {
        String string = this.getHeader(name);
        return string == null ? -1 : Integer.parseInt(string);
    }

    public void setIntHeader(String name, int value) {
        this.setHeader(name, String.valueOf(value));
    }

    public void addIntHeader(String name, int value) {
        this.addHeader(name, String.valueOf(value));
    }

    public int getContentLength() {
        return this.getIntHeader("Content-Length");
    }

    public void setContentLength(int length) {
        this.setIntHeader("Content-Length", length);
    }

    public String getContentType() {
        return this.getHeader("Content-Type");
    }

    public void setContentType(String type) {
        this.setHeader("Content-Type", type);
    }

    public void setCharacterEncoding(String newEncoding) throws UnsupportedEncodingException {
        if (newEncoding == null) {
            return;
        }
        String contentType = this.getContentType();
        if (contentType == null) {
            return;
        }
        String currentEncoding = this.getCharacterEncoding();
        if (currentEncoding == null) {
            this.setContentType(contentType + "; " + "charset=" + newEncoding);
        } else {
            contentType = contentType.substring(0, contentType.indexOf("charset="));
            this.setContentType(contentType + "charset=" + newEncoding);
        }
    }

    public String getCharacterEncoding() {
        String type = this.getContentType();
        if (type == null) {
            return null;
        }
        int start = type.indexOf("charset=");
        if (start == -1) {
            return null;
        }
        start += "charset=".length();
        StringBuffer buffer = new StringBuffer();
        while (start < type.length() && type.charAt(start) != ';') {
            buffer.append(type.charAt(start++));
        }
        String charset = buffer.toString();
        if (charset.startsWith("\"")) {
            return charset.substring(1, charset.length() - 1);
        }
        return charset;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getDateHeader(String name) {
        String string = this.getHeader(name);
        if (string == null) {
            return -1L;
        }
        try {
            SimpleDateFormat simpleDateFormat = dateFormatter1;
            synchronized (simpleDateFormat) {
                Date date = dateFormatter1.parse(string, new ParsePosition(0));
                return date.getTime();
            }
        }
        catch (Exception exception) {
            try {
                SimpleDateFormat date = dateFormatter2;
                synchronized (date) {
                    Date date2 = dateFormatter2.parse(string, new ParsePosition(0));
                    return date2.getTime();
                }
            }
            catch (Exception throwable) {
                throw new IllegalArgumentException("header cannot be converted to date:" + name + "/" + string);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setDateHeader(String name, long date) {
        SimpleDateFormat simpleDateFormat = dateFormatter1;
        synchronized (simpleDateFormat) {
            this.setHeader(name, dateFormatter1.format(new Date(date)));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addDateHeader(String name, long date) {
        SimpleDateFormat simpleDateFormat = dateFormatter1;
        synchronized (simpleDateFormat) {
            this.addHeader(name, dateFormatter1.format(new Date(date)));
        }
    }

    private static void initDateFormatters() {
        dateFormatter1 = new SimpleDateFormat("EEE, dd MMM yyyy HH:mm:ss z", Locale.US);
        dateFormatter1.setTimeZone(gmt);
        dateFormatter2 = new SimpleDateFormat("EEEEE, dd-MMM-yy HH:mm:ss z", Locale.US);
        dateFormatter2.setTimeZone(gmt);
        dateFormatter3 = new SimpleDateFormat("EEE MMM dd HH:mm:ss yyyy", Locale.US);
        dateFormatter3.setTimeZone(gmt);
    }

    static {
        MIMEHeaders.initDateFormatters();
    }
}

