/*
 * Decompiled with CFR 0.152.
 */
package electric.util.jms;

import java.io.IOException;
import java.io.InputStream;
import javax.jms.BytesMessage;
import javax.jms.JMSException;

public class MessageInputStream
extends InputStream {
    private BytesMessage message;

    public MessageInputStream(BytesMessage message) {
        this.message = message;
    }

    public int read() throws IOException {
        try {
            return this.message.readByte();
        }
        catch (JMSException exception) {
            throw new IOException(exception.toString());
        }
    }

    public int read(byte[] b) throws IOException {
        try {
            return this.message.readBytes(b);
        }
        catch (JMSException exception) {
            throw new IOException(exception.toString());
        }
    }

    public int read(byte[] b, int off, int len) throws IOException {
        try {
            return this.message.readBytes(b, len);
        }
        catch (JMSException exception) {
            throw new IOException(exception.toString());
        }
    }
}

